/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.coverage;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.CoverageUtils;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.ElementsAndCoveredElementsVariationCounter;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredMetricKeys;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public final class LinesAndConditionsWithUncoveredVariationCounter
extends ElementsAndCoveredElementsVariationCounter {
    private final LinesAndConditionsWithUncoveredMetricKeys metricKeys;

    public LinesAndConditionsWithUncoveredVariationCounter(LinesAndConditionsWithUncoveredMetricKeys metricKeys) {
        this.metricKeys = metricKeys;
    }

    @Override
    public void initializeForSupportedLeaf(CounterInitializationContext counterContext) {
        Optional<Measure> newLinesMeasure = counterContext.getMeasure(this.metricKeys.getLines());
        if (!newLinesMeasure.isPresent() || !((Measure)newLinesMeasure.get()).hasVariation()) {
            return;
        }
        double newLines = ((Measure)newLinesMeasure.get()).getVariation();
        long newConditions = (long)CoverageUtils.getMeasureVariations(counterContext, this.metricKeys.getConditions());
        long uncoveredLines = (long)CoverageUtils.getMeasureVariations(counterContext, this.metricKeys.getUncoveredLines());
        long uncoveredConditions = (long)CoverageUtils.getMeasureVariations(counterContext, this.metricKeys.getUncoveredConditions());
        long elements = (long)newLines + newConditions;
        this.elements.increment(elements);
        this.coveredElements.increment(elements - uncoveredConditions - uncoveredLines);
    }
}

