/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.dbmigration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.computation.task.projectanalysis.dbmigration.PopulateFileSourceLineCount;
import org.sonar.server.computation.task.projectanalysis.dbmigration.ProjectAnalysisDataChange;
import org.sonar.server.computation.task.projectanalysis.dbmigration.ProjectAnalysisDataChanges;

public class ProjectAnalysisDataChangesImpl
implements ProjectAnalysisDataChanges {
    private static final List<Class<? extends ProjectAnalysisDataChange>> DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION = ImmutableList.of(PopulateFileSourceLineCount.class);
    private final List<ProjectAnalysisDataChange> dataChangeInstances;

    public ProjectAnalysisDataChangesImpl(ProjectAnalysisDataChange[] dataChanges) {
        Preconditions.checkArgument((dataChanges.length == DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION.size() ? 1 : 0) != 0, (String)"Number of ProjectAnalysisDataChange instance available (%s) is inconsistent with the number of declared ProjectAnalysisDataChange types (%s)", (Object[])new Object[]{dataChanges.length, DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION.size()});
        Map dataChangesByClass = (Map)Arrays.stream(dataChanges).collect(MoreCollectors.uniqueIndex(Object::getClass));
        this.dataChangeInstances = (List)DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION.stream().map(dataChangesByClass::get).filter(Objects::nonNull).collect(MoreCollectors.toList((int)DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION.size()));
        Preconditions.checkState((this.dataChangeInstances.size() == DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION.size() ? 1 : 0) != 0, (Object)"Some of the ProjectAnalysisDataChange type declared have no instance in the container");
    }

    static List<Class<? extends ProjectAnalysisDataChange>> getDataChangeClasses() {
        return DATA_CHANGE_CLASSES_IN_ORDER_OF_EXECUTION;
    }

    @Override
    public List<ProjectAnalysisDataChange> getDataChanges() {
        return this.dataChangeInstances;
    }
}

