/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.analysis;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.organization.OrganizationDto;

@Immutable
public class Organization {
    private final String uuid;
    private final String key;
    private final String name;
    private final String defaultQualityGateUuid;

    private Organization(String uuid, String key, String name, String defaultQualityGateUuid) {
        this.uuid = Objects.requireNonNull(uuid, "uuid can't be null");
        this.key = Objects.requireNonNull(key, "key can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.defaultQualityGateUuid = Objects.requireNonNull(defaultQualityGateUuid, "defaultQualityGateUuid can't be null");
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultQualityGateUuid() {
        return this.defaultQualityGateUuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization that = (Organization)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "Organization{uuid='" + this.uuid + '\'' + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", defaultQualityGateUuid='" + this.defaultQualityGateUuid + '\'' + '}';
    }

    public OrganizationDto toDto() {
        return new OrganizationDto().setName(this.name).setKey(this.key).setUuid(this.uuid).setDefaultQualityGateUuid(this.defaultQualityGateUuid);
    }

    public static Organization from(OrganizationDto organizationDto) {
        return new Organization(organizationDto.getUuid(), organizationDto.getKey(), organizationDto.getName(), organizationDto.getDefaultQualityGateUuid());
    }
}

