/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.user.UserSession;

public class AppAction
implements ComponentsWsAction {
    private static final String PARAM_COMPONENT_ID = "componentId";
    private static final String PARAM_COMPONENT = "component";
    private static final List<String> METRIC_KEYS = Collections.unmodifiableList(Arrays.asList("lines", "violations", "coverage", "duplicated_lines_density", "tests"));
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public AppAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("app").setDescription("Coverage data required for rendering the component viewer.<br>Requires the following permission: 'Browse'.").setResponseExample(this.getClass().getResource("app-example.json")).setSince("4.4").setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_COMPONENT_ID).setDescription("Component ID").setDeprecatedSince("6.4").setDeprecatedKey("uuid", "6.4").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam(PARAM_COMPONENT).setDescription("Component key").setExampleValue((Object)"my_project").setSince("6.4");
        action.createParam("branch").setDescription("Branch key").setSince("6.6").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam("pullRequest").setDescription("Pull request id").setSince("7.1").setInternal(true).setExampleValue((Object)"5461");
    }

    public void handle(Request request, Response response) {
        try (DbSession session = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(session, request);
            this.userSession.checkComponentPermission("user", component);
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            Map<String, LiveMeasureDto> measuresByMetricKey = this.loadMeasuresGroupedByMetricKey(component, session);
            this.appendComponent(json, component, this.userSession, session);
            AppAction.appendPermissions(json, this.userSession);
            AppAction.appendMeasures(json, measuresByMetricKey);
            json.endObject();
            json.close();
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentUuid = request.param(PARAM_COMPONENT_ID);
        String branch = request.param("branch");
        String pullRequest = request.param("pullRequest");
        Preconditions.checkArgument((componentUuid == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{PARAM_COMPONENT_ID, "branch", "pullRequest"});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentUuid, request.param(PARAM_COMPONENT), ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT);
        }
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, request.mandatoryParam(PARAM_COMPONENT), branch, pullRequest);
    }

    private void appendComponent(JsonWriter json, ComponentDto component, UserSession userSession, DbSession session) {
        String pullRequest;
        List propertyDtos = this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setKey("favourite").setComponentId(component.getId()).setUserId(userSession.getUserId()).build(), session);
        boolean isFavourite = propertyDtos.size() == 1;
        json.prop("key", component.getKey());
        json.prop("uuid", component.uuid());
        json.prop("path", component.path());
        json.prop("name", component.name());
        json.prop("longName", component.longName());
        json.prop("q", component.qualifier());
        ComponentDto parentProject = this.retrieveRootIfNotCurrentComponent(component, session);
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(session, component.projectUuid());
        boolean displayParentProject = parentProject != null && !parentProject.uuid().equals(project.uuid());
        json.prop("subProject", displayParentProject ? parentProject.getKey() : null);
        json.prop("subProjectName", displayParentProject ? parentProject.longName() : null);
        json.prop("project", project.getKey());
        json.prop("projectName", project.longName());
        String branch = project.getBranch();
        if (branch != null) {
            json.prop("branch", branch);
        }
        if ((pullRequest = project.getPullRequest()) != null) {
            json.prop("pullRequest", pullRequest);
        }
        json.prop("fav", isFavourite);
    }

    private static void appendPermissions(JsonWriter json, UserSession userSession) {
        json.prop("canMarkAsFavorite", userSession.isLoggedIn());
    }

    private static void appendMeasures(JsonWriter json, Map<String, LiveMeasureDto> measuresByMetricKey) {
        json.name("measures").beginObject();
        json.prop("lines", AppAction.formatMeasure(measuresByMetricKey, CoreMetrics.LINES));
        json.prop("coverage", AppAction.formatMeasure(measuresByMetricKey, CoreMetrics.COVERAGE));
        json.prop("duplicationDensity", AppAction.formatMeasure(measuresByMetricKey, CoreMetrics.DUPLICATED_LINES_DENSITY));
        json.prop("issues", AppAction.formatMeasure(measuresByMetricKey, CoreMetrics.VIOLATIONS));
        json.prop("tests", AppAction.formatMeasure(measuresByMetricKey, CoreMetrics.TESTS));
        json.endObject();
    }

    private Map<String, LiveMeasureDto> loadMeasuresGroupedByMetricKey(ComponentDto component, DbSession dbSession) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, METRIC_KEYS);
        ImmutableMap metricsById = Maps.uniqueIndex((Iterable)metrics, MetricDto::getId);
        List measures = this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricIds(dbSession, Collections.singletonList(component.uuid()), metricsById.keySet());
        return Maps.uniqueIndex((Iterable)measures, arg_0 -> AppAction.lambda$loadMeasuresGroupedByMetricKey$0((Map)metricsById, arg_0));
    }

    @CheckForNull
    private ComponentDto retrieveRootIfNotCurrentComponent(ComponentDto componentDto, DbSession session) {
        if (componentDto.uuid().equals(componentDto.getRootUuid())) {
            return null;
        }
        return this.dbClient.componentDao().selectOrFailByUuid(session, componentDto.getRootUuid());
    }

    @CheckForNull
    private static String formatMeasure(Map<String, LiveMeasureDto> measuresByMetricKey, Metric metric) {
        LiveMeasureDto measure = measuresByMetricKey.get(metric.getKey());
        return AppAction.formatMeasure(measure, metric);
    }

    private static String formatMeasure(@Nullable LiveMeasureDto measure, Metric metric) {
        if (measure == null) {
            return null;
        }
        Double value = AppAction.getDoubleValue(measure, metric);
        if (value != null) {
            return Double.toString(value);
        }
        return null;
    }

    @CheckForNull
    private static Double getDoubleValue(LiveMeasureDto measure, Metric metric) {
        Double value = measure.getValue();
        if (BooleanUtils.isTrue((Boolean)metric.isOptimizedBestValue()) && value == null) {
            value = metric.getBestValue();
        }
        return value;
    }

    private static /* synthetic */ String lambda$loadMeasuresGroupedByMetricKey$0(Map metricsById, LiveMeasureDto m) {
        return ((MetricDto)metricsById.get(m.getMetricId())).getKey();
    }
}

