/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.ce.configuration.WorkerCountProvider;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class WorkerCountAction
implements CeWsAction {
    private static final int DEFAULT_WORKER_COUNT = 1;
    private final UserSession userSession;
    private final WorkerCountProvider workerCountProvider;

    public WorkerCountAction(UserSession userSession, @Nullable WorkerCountProvider workerCountProvider) {
        this.userSession = userSession;
        this.workerCountProvider = workerCountProvider;
    }

    public WorkerCountAction(UserSession userSession) {
        this(userSession, null);
    }

    @Override
    public void define(WebService.NewController controller) {
        controller.createAction("worker_count").setDescription("Return number of Compute Engine workers.<br/>Requires the system administration permission").setResponseExample(this.getClass().getResource("worker_count-example.json")).setSince("6.5").setInternal(true).setHandler((RequestHandler)this);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        WsUtils.writeProtobuf((Message)this.createResponse(), wsRequest, wsResponse);
    }

    private Ce.WorkerCountResponse createResponse() {
        Ce.WorkerCountResponse.Builder builder = Ce.WorkerCountResponse.newBuilder();
        if (this.workerCountProvider == null) {
            return builder.setValue(1).setCanSetWorkerCount(false).build();
        }
        return builder.setValue(this.workerCountProvider.get()).setCanSetWorkerCount(true).build();
    }
}

