/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.authentication.UserIdentityAuthenticator;
import org.sonar.server.authentication.UserIdentityAuthenticatorParameters;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.authentication.exception.EmailAlreadyExistsRedirectionException;
import org.sonar.server.authentication.exception.UpdateLoginRedirectionException;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.OrganizationUpdater;
import org.sonar.server.user.ExternalIdentity;
import org.sonar.server.user.NewUser;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.usergroups.DefaultGroupFinder;

public class UserIdentityAuthenticatorImpl
implements UserIdentityAuthenticator {
    private static final Logger LOGGER = Loggers.get(UserIdentityAuthenticatorImpl.class);
    private final DbClient dbClient;
    private final UserUpdater userUpdater;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganizationFlags organizationFlags;
    private final OrganizationUpdater organizationUpdater;
    private final DefaultGroupFinder defaultGroupFinder;

    public UserIdentityAuthenticatorImpl(DbClient dbClient, UserUpdater userUpdater, DefaultOrganizationProvider defaultOrganizationProvider, OrganizationFlags organizationFlags, OrganizationUpdater organizationUpdater, DefaultGroupFinder defaultGroupFinder) {
        this.dbClient = dbClient;
        this.userUpdater = userUpdater;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organizationFlags = organizationFlags;
        this.organizationUpdater = organizationUpdater;
        this.defaultGroupFinder = defaultGroupFinder;
    }

    @Override
    public UserDto authenticate(UserIdentityAuthenticatorParameters authenticatorParameters) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.getUser(dbSession, authenticatorParameters.getUserIdentity(), authenticatorParameters.getProvider());
            if (userDto == null) {
                UserDto userDto2 = this.registerNewUser(dbSession, null, authenticatorParameters);
                return userDto2;
            }
            if (!userDto.isActive()) {
                UserDto userDto3 = this.registerNewUser(dbSession, userDto, authenticatorParameters);
                return userDto3;
            }
            UserDto userDto4 = this.registerExistingUser(dbSession, userDto, authenticatorParameters);
            return userDto4;
        }
    }

    @CheckForNull
    private UserDto getUser(DbSession dbSession, UserIdentity userIdentity, IdentityProvider provider) {
        String externalId = userIdentity.getProviderId();
        UserDto user = this.dbClient.userDao().selectByExternalIdAndIdentityProvider(dbSession, externalId == null ? userIdentity.getProviderLogin() : externalId, provider.getKey());
        return user != null ? user : this.dbClient.userDao().selectByLogin(dbSession, userIdentity.getLogin());
    }

    private UserDto registerExistingUser(DbSession dbSession, UserDto userDto, UserIdentityAuthenticatorParameters authenticatorParameters) {
        UpdateUser update = new UpdateUser().setLogin(authenticatorParameters.getUserIdentity().getLogin()).setEmail(authenticatorParameters.getUserIdentity().getEmail()).setName(authenticatorParameters.getUserIdentity().getName()).setExternalIdentity(new ExternalIdentity(authenticatorParameters.getProvider().getKey(), authenticatorParameters.getUserIdentity().getProviderLogin(), authenticatorParameters.getUserIdentity().getProviderId()));
        this.detectLoginUpdate(dbSession, userDto, update, authenticatorParameters);
        Optional<UserDto> otherUserToIndex = this.detectEmailUpdate(dbSession, authenticatorParameters);
        this.userUpdater.updateAndCommit(dbSession, userDto, update, u -> this.syncGroups(dbSession, authenticatorParameters.getUserIdentity(), (UserDto)u), UserIdentityAuthenticatorImpl.toArray(otherUserToIndex));
        return userDto;
    }

    private UserDto registerNewUser(DbSession dbSession, @Nullable UserDto disabledUser, UserIdentityAuthenticatorParameters authenticatorParameters) {
        Optional<UserDto> otherUserToIndex = this.detectEmailUpdate(dbSession, authenticatorParameters);
        NewUser newUser = UserIdentityAuthenticatorImpl.createNewUser(authenticatorParameters);
        if (disabledUser == null) {
            return this.userUpdater.createAndCommit(dbSession, newUser, u -> this.syncGroups(dbSession, authenticatorParameters.getUserIdentity(), (UserDto)u), UserIdentityAuthenticatorImpl.toArray(otherUserToIndex));
        }
        return this.userUpdater.reactivateAndCommit(dbSession, disabledUser, newUser, u -> this.syncGroups(dbSession, authenticatorParameters.getUserIdentity(), (UserDto)u), UserIdentityAuthenticatorImpl.toArray(otherUserToIndex));
    }

    private Optional<UserDto> detectEmailUpdate(DbSession dbSession, UserIdentityAuthenticatorParameters authenticatorParameters) {
        String email = authenticatorParameters.getUserIdentity().getEmail();
        if (email == null) {
            return Optional.empty();
        }
        List existingUsers = this.dbClient.userDao().selectByEmail(dbSession, email);
        if (existingUsers.isEmpty()) {
            return Optional.empty();
        }
        if (existingUsers.size() > 1) {
            throw UserIdentityAuthenticatorImpl.generateExistingEmailError(authenticatorParameters, email);
        }
        UserDto existingUser = (UserDto)existingUsers.get(0);
        if (existingUser == null || Objects.equals(existingUser.getLogin(), authenticatorParameters.getUserIdentity().getLogin()) || Objects.equals(existingUser.getExternalId(), authenticatorParameters.getUserIdentity().getProviderId()) && Objects.equals(existingUser.getExternalIdentityProvider(), authenticatorParameters.getProvider().getKey())) {
            return Optional.empty();
        }
        UserIdentityAuthenticatorParameters.ExistingEmailStrategy existingEmailStrategy = authenticatorParameters.getExistingEmailStrategy();
        switch (existingEmailStrategy) {
            case ALLOW: {
                existingUser.setEmail(null);
                this.dbClient.userDao().update(dbSession, existingUser);
                return Optional.of(existingUser);
            }
            case WARN: {
                throw new EmailAlreadyExistsRedirectionException(email, existingUser, authenticatorParameters.getUserIdentity(), authenticatorParameters.getProvider());
            }
            case FORBID: {
                throw UserIdentityAuthenticatorImpl.generateExistingEmailError(authenticatorParameters, email);
            }
        }
        throw new IllegalStateException(String.format("Unknown strategy %s", new Object[]{existingEmailStrategy}));
    }

    private void detectLoginUpdate(DbSession dbSession, UserDto user, UpdateUser update, UserIdentityAuthenticatorParameters authenticatorParameters) {
        String newLogin = update.login();
        if (!update.isLoginChanged() || user.getLogin().equals(newLogin)) {
            return;
        }
        if (!this.organizationFlags.isEnabled(dbSession)) {
            return;
        }
        String personalOrganizationUuid = user.getOrganizationUuid();
        if (personalOrganizationUuid == null) {
            return;
        }
        Optional personalOrganization = this.dbClient.organizationDao().selectByUuid(dbSession, personalOrganizationUuid);
        Preconditions.checkState((boolean)personalOrganization.isPresent(), (String)"Cannot find personal organization uuid '%s' for user '%s'", (Object[])new Object[]{personalOrganizationUuid, user.getLogin()});
        UserIdentityAuthenticatorParameters.UpdateLoginStrategy updateLoginStrategy = authenticatorParameters.getUpdateLoginStrategy();
        switch (updateLoginStrategy) {
            case ALLOW: {
                this.organizationUpdater.updateOrganizationKey(dbSession, (OrganizationDto)personalOrganization.get(), Objects.requireNonNull(newLogin, "new login cannot be null"));
                return;
            }
            case WARN: {
                throw new UpdateLoginRedirectionException(authenticatorParameters.getUserIdentity(), authenticatorParameters.getProvider(), user, (OrganizationDto)personalOrganization.get());
            }
        }
        throw new IllegalStateException(String.format("Unknown strategy %s", new Object[]{updateLoginStrategy}));
    }

    private void syncGroups(DbSession dbSession, UserIdentity userIdentity, UserDto userDto) {
        if (!userIdentity.shouldSyncGroups()) {
            return;
        }
        String userLogin = userIdentity.getLogin();
        HashSet userGroups = new HashSet(this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(userLogin)).get((Object)userLogin));
        Set identityGroups = userIdentity.getGroups();
        LOGGER.debug("List of groups returned by the identity provider '{}'", (Object)identityGroups);
        Sets.SetView groupsToAdd = Sets.difference((Set)identityGroups, userGroups);
        Sets.SetView groupsToRemove = Sets.difference(userGroups, (Set)identityGroups);
        ArrayList allGroups = new ArrayList(groupsToAdd);
        allGroups.addAll(groupsToRemove);
        DefaultOrganization defaultOrganization = this.defaultOrganizationProvider.get();
        Map groupsByName = (Map)this.dbClient.groupDao().selectByNames(dbSession, defaultOrganization.getUuid(), allGroups).stream().collect(MoreCollectors.uniqueIndex(GroupDto::getName));
        this.addGroups(dbSession, userDto, (Collection<String>)groupsToAdd, groupsByName);
        this.removeGroups(dbSession, userDto, (Collection<String>)groupsToRemove, groupsByName);
    }

    private void addGroups(DbSession dbSession, UserDto userDto, Collection<String> groupsToAdd, Map<String, GroupDto> groupsByName) {
        groupsToAdd.stream().map(groupsByName::get).filter(Objects::nonNull).forEach(groupDto -> {
            LOGGER.debug("Adding group '{}' to user '{}'", (Object)groupDto.getName(), (Object)userDto.getLogin());
            this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(groupDto.getId().intValue()).setUserId(userDto.getId().intValue()));
        });
    }

    private void removeGroups(DbSession dbSession, UserDto userDto, Collection<String> groupsToRemove, Map<String, GroupDto> groupsByName) {
        Optional<GroupDto> defaultGroup = this.getDefaultGroup(dbSession);
        groupsToRemove.stream().map(groupsByName::get).filter(Objects::nonNull).filter(group -> !defaultGroup.isPresent() || !group.getId().equals(((GroupDto)defaultGroup.get()).getId())).forEach(groupDto -> {
            LOGGER.debug("Removing group '{}' from user '{}'", (Object)groupDto.getName(), (Object)userDto.getLogin());
            this.dbClient.userGroupDao().delete(dbSession, groupDto.getId().intValue(), userDto.getId().intValue());
        });
    }

    private Optional<GroupDto> getDefaultGroup(DbSession dbSession) {
        return this.organizationFlags.isEnabled(dbSession) ? Optional.empty() : Optional.of(this.defaultGroupFinder.findDefaultGroup(dbSession, this.defaultOrganizationProvider.get().getUuid()));
    }

    private static NewUser createNewUser(UserIdentityAuthenticatorParameters authenticatorParameters) {
        String identityProviderKey = authenticatorParameters.getProvider().getKey();
        if (!authenticatorParameters.getProvider().allowsUsersToSignUp()) {
            throw AuthenticationException.newBuilder().setSource(authenticatorParameters.getSource()).setLogin(authenticatorParameters.getUserIdentity().getLogin()).setMessage(String.format("User signup disabled for provider '%s'", identityProviderKey)).setPublicMessage(String.format("'%s' users are not allowed to sign up", identityProviderKey)).build();
        }
        return NewUser.builder().setLogin(authenticatorParameters.getUserIdentity().getLogin()).setEmail(authenticatorParameters.getUserIdentity().getEmail()).setName(authenticatorParameters.getUserIdentity().getName()).setExternalIdentity(new ExternalIdentity(identityProviderKey, authenticatorParameters.getUserIdentity().getProviderLogin(), authenticatorParameters.getUserIdentity().getProviderId())).build();
    }

    /*
     * Exception decompiling
     */
    private static UserDto[] toArray(Optional<UserDto> userDto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static AuthenticationException generateExistingEmailError(UserIdentityAuthenticatorParameters authenticatorParameters, String email) {
        return AuthenticationException.newBuilder().setSource(authenticatorParameters.getSource()).setLogin(authenticatorParameters.getUserIdentity().getLogin()).setMessage(String.format("Email '%s' is already used", email)).setPublicMessage(String.format("You can't sign up because email '%s' is already used by an existing user. This means that you probably already registered with another account.", email)).build();
    }
}

