/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;

class TomcatStartupLogs {
    private final Logger log;

    TomcatStartupLogs(Logger log) {
        this.log = log;
    }

    void log(Tomcat tomcat) {
        Connector[] connectors;
        for (Connector connector : connectors = tomcat.getService().findConnectors()) {
            if (!StringUtils.equalsIgnoreCase((String)connector.getScheme(), (String)"http")) {
                throw new IllegalArgumentException("Unsupported connector: " + connector);
            }
            this.logHttp(connector);
        }
    }

    private void logHttp(Connector connector) {
        this.log.info(String.format("HTTP connector enabled on port %d", connector.getPort()));
    }
}

