/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.sonar.api.server.ServerSide;
import org.sonar.ce.queue.CeQueue;
import org.sonar.ce.queue.CeTask;
import org.sonar.ce.queue.CeTaskSubmit;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.organization.DefaultOrganizationProvider;

@ServerSide
public class CeQueueImpl
implements CeQueue {
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public CeQueueImpl(DbClient dbClient, UuidFactory uuidFactory, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    @Override
    public CeTaskSubmit.Builder prepareSubmit() {
        return new CeTaskSubmit.Builder(this.uuidFactory.create());
    }

    @Override
    public CeTask submit(CeTaskSubmit submission) {
        return this.submit(submission, EnumSet.noneOf(CeQueue.SubmitOption.class)).get();
    }

    @Override
    public Optional<CeTask> submit(CeTaskSubmit submission, CeQueue.SubmitOption ... options) {
        return this.submit(submission, CeQueueImpl.toSet(options));
    }

    private Optional<CeTask> submit(CeTaskSubmit submission, EnumSet<CeQueue.SubmitOption> submitOptions) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (submitOptions.contains((Object)CeQueue.SubmitOption.UNIQUE_QUEUE_PER_COMPONENT) && submission.getComponentUuid() != null && this.dbClient.ceQueueDao().countByStatusAndComponentUuid(dbSession, CeQueueDto.Status.PENDING, submission.getComponentUuid()) > 0) {
                Optional<CeTask> optional = Optional.empty();
                return optional;
            }
            CeQueueDto dto = this.addToQueueInDb(dbSession, submission);
            CeTask task = this.loadTask(dbSession, dto);
            dbSession.commit();
            Optional<CeTask> optional = Optional.of(task);
            return optional;
        }
    }

    @Override
    public List<CeTask> massSubmit(Collection<CeTaskSubmit> submissions, CeQueue.SubmitOption ... options) {
        if (submissions.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession dbSession = this.dbClient.openSession(true);){
            List<CeQueueDto> ceQueueDtos = submissions.stream().filter(this.filterBySubmitOptions(options, submissions, dbSession)).map(submission -> this.addToQueueInDb(dbSession, (CeTaskSubmit)submission)).collect(Collectors.toList());
            List<CeTask> tasks = this.loadTasks(dbSession, ceQueueDtos);
            dbSession.commit();
            List<CeTask> list = tasks;
            return list;
        }
    }

    private Predicate<CeTaskSubmit> filterBySubmitOptions(CeQueue.SubmitOption[] options, Collection<CeTaskSubmit> submissions, DbSession dbSession) {
        EnumSet<CeQueue.SubmitOption> submitOptions = CeQueueImpl.toSet(options);
        if (submitOptions.contains((Object)CeQueue.SubmitOption.UNIQUE_QUEUE_PER_COMPONENT)) {
            Set componentUuids = (Set)submissions.stream().map(CeTaskSubmit::getComponentUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet((int)submissions.size()));
            if (componentUuids.isEmpty()) {
                return t -> true;
            }
            return new NoPendingTaskFilter(dbSession, componentUuids);
        }
        return t -> true;
    }

    private static EnumSet<CeQueue.SubmitOption> toSet(CeQueue.SubmitOption[] options) {
        return (EnumSet)Arrays.stream(options).collect(MoreCollectors.toEnumSet(CeQueue.SubmitOption.class));
    }

    private CeQueueDto addToQueueInDb(DbSession dbSession, CeTaskSubmit submission) {
        CeQueueDto dto = new CeQueueDto();
        dto.setUuid(submission.getUuid());
        dto.setTaskType(submission.getType());
        dto.setComponentUuid(submission.getComponentUuid());
        dto.setStatus(CeQueueDto.Status.PENDING);
        dto.setSubmitterUuid(submission.getSubmitterUuid());
        dto.setStartedAt(null);
        this.dbClient.ceQueueDao().insert(dbSession, dto);
        return dto;
    }

    protected CeTask loadTask(DbSession dbSession, CeQueueDto dto) {
        String componentUuid = dto.getComponentUuid();
        if (componentUuid == null) {
            return new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid()).apply(dto);
        }
        com.google.common.base.Optional componentDto = this.dbClient.componentDao().selectByUuid(dbSession, componentUuid);
        if (componentDto.isPresent()) {
            return new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid(), (Map)ImmutableMap.of((Object)componentUuid, (Object)componentDto.get())).apply(dto);
        }
        return new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid()).apply(dto);
    }

    private List<CeTask> loadTasks(DbSession dbSession, List<CeQueueDto> dtos) {
        Set componentUuids = dtos.stream().map(CeQueueDto::getComponentUuid).filter(Objects::nonNull).collect(Collectors.toSet());
        ImmutableMap componentDtoByUuid = FluentIterable.from((Iterable)this.dbClient.componentDao().selectByUuids(dbSession, componentUuids)).uniqueIndex(ComponentDto::uuid);
        return (List)dtos.stream().map(new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid(), (Map)componentDtoByUuid)::apply).collect(MoreCollectors.toList((int)dtos.size()));
    }

    @Override
    public void cancel(DbSession dbSession, CeQueueDto ceQueueDto) {
        Preconditions.checkState((boolean)CeQueueDto.Status.PENDING.equals((Object)ceQueueDto.getStatus()), (String)"Task is in progress and can't be canceled [uuid=%s]", (Object[])new Object[]{ceQueueDto.getUuid()});
        this.cancelImpl(dbSession, ceQueueDto);
    }

    private void cancelImpl(DbSession dbSession, CeQueueDto q) {
        CeActivityDto activityDto = new CeActivityDto(q);
        activityDto.setStatus(CeActivityDto.Status.CANCELED);
        this.remove(dbSession, q, activityDto);
    }

    @Override
    public int cancelAll() {
        return this.cancelAll(false);
    }

    protected int cancelAll(boolean includeInProgress) {
        int count = 0;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            for (CeQueueDto queueDto : this.dbClient.ceQueueDao().selectAllInAscOrder(dbSession)) {
                if (!includeInProgress && queueDto.getStatus().equals((Object)CeQueueDto.Status.IN_PROGRESS)) continue;
                this.cancelImpl(dbSession, queueDto);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public void pauseWorkers() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.internalPropertiesDao().save(dbSession, "ce.pause", "true");
            dbSession.commit();
        }
    }

    @Override
    public void resumeWorkers() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.internalPropertiesDao().delete(dbSession, "ce.pause");
            dbSession.commit();
        }
    }

    @Override
    public CeQueue.WorkersPauseStatus getWorkersPauseStatus() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional propValue = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "ce.pause");
            if (!propValue.isPresent() || !((String)propValue.get()).equals("true")) {
                CeQueue.WorkersPauseStatus workersPauseStatus = CeQueue.WorkersPauseStatus.RESUMED;
                return workersPauseStatus;
            }
            int countInProgress = this.dbClient.ceQueueDao().countByStatus(dbSession, CeQueueDto.Status.IN_PROGRESS);
            if (countInProgress > 0) {
                CeQueue.WorkersPauseStatus workersPauseStatus = CeQueue.WorkersPauseStatus.PAUSING;
                return workersPauseStatus;
            }
            CeQueue.WorkersPauseStatus workersPauseStatus = CeQueue.WorkersPauseStatus.PAUSED;
            return workersPauseStatus;
        }
    }

    protected void remove(DbSession dbSession, CeQueueDto queueDto, CeActivityDto activityDto) {
        this.dbClient.ceActivityDao().insert(dbSession, activityDto);
        this.dbClient.ceQueueDao().deleteByUuid(dbSession, queueDto.getUuid());
        this.dbClient.ceTaskInputDao().deleteByUuids(dbSession, Collections.singleton(queueDto.getUuid()));
        dbSession.commit();
    }

    private static class CeQueueDtoToCeTask
    implements Function<CeQueueDto, CeTask> {
        private final String defaultOrganizationUuid;
        private final Map<String, ComponentDto> componentDtoByUuid;

        private CeQueueDtoToCeTask(String defaultOrganizationUuid) {
            this(defaultOrganizationUuid, Collections.emptyMap());
        }

        private CeQueueDtoToCeTask(String defaultOrganizationUuid, Map<String, ComponentDto> componentDtoByUuid) {
            this.defaultOrganizationUuid = Objects.requireNonNull(defaultOrganizationUuid, "defaultOrganizationUuid can't be null");
            this.componentDtoByUuid = componentDtoByUuid;
        }

        @Nonnull
        public CeTask apply(@Nonnull CeQueueDto dto) {
            CeTask.Builder builder = new CeTask.Builder();
            builder.setUuid(dto.getUuid());
            builder.setType(dto.getTaskType());
            builder.setSubmitterUuid(dto.getSubmitterUuid());
            String componentUuid = dto.getComponentUuid();
            if (componentUuid != null) {
                builder.setComponentUuid(componentUuid);
                ComponentDto component = this.componentDtoByUuid.get(componentUuid);
                if (component != null) {
                    builder.setOrganizationUuid(component.getOrganizationUuid());
                    builder.setComponentKey(component.getDbKey());
                    builder.setComponentName(component.name());
                }
            }
            if (!builder.hasOrganizationUuid()) {
                builder.setOrganizationUuid(this.defaultOrganizationUuid);
            }
            return builder.build();
        }
    }

    private class NoPendingTaskFilter
    implements Predicate<CeTaskSubmit> {
        private final Map<String, Integer> queuedItemsByComponentUuid;

        private NoPendingTaskFilter(DbSession dbSession, Set<String> componentUuids) {
            this.queuedItemsByComponentUuid = CeQueueImpl.this.dbClient.ceQueueDao().countByStatusAndComponentUuids(dbSession, CeQueueDto.Status.PENDING, componentUuids);
        }

        @Override
        public boolean test(CeTaskSubmit ceTaskSubmit) {
            String componentUuid = ceTaskSubmit.getComponentUuid();
            return componentUuid == null || this.queuedItemsByComponentUuid.getOrDefault(componentUuid, 0) == 0;
        }
    }
}

