/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.web.ServletFilter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.ws.ServletFilterHandler;
import org.sonar.server.ws.ServletRequest;
import org.sonar.server.ws.ServletResponse;
import org.sonar.server.ws.WebServiceEngine;
import org.sonar.server.ws.WebServiceReroutingFilter;

public class WebServiceFilter
extends ServletFilter {
    private final WebServiceEngine webServiceEngine;
    private final Set<String> includeUrls;
    private final Set<String> excludeUrls;

    public WebServiceFilter(WebServiceEngine webServiceEngine) {
        this.webServiceEngine = webServiceEngine;
        this.includeUrls = (Set)Stream.concat(Stream.of("/api/*"), webServiceEngine.controllers().stream().flatMap(controller -> controller.actions().stream()).map(WebServiceFilter.toPath())).collect(MoreCollectors.toSet());
        this.excludeUrls = (Set)Stream.concat(Stream.concat(Stream.of("/api/properties*"), WebServiceReroutingFilter.MOVED_WEB_SERVICES.stream()), webServiceEngine.controllers().stream().flatMap(controller -> controller.actions().stream()).filter(action -> action.handler() instanceof ServletFilterHandler).map(WebServiceFilter.toPath())).collect(MoreCollectors.toSet());
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.builder().includes(this.includeUrls).excludes(this.excludeUrls).build();
    }

    public void doFilter(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ServletRequest wsRequest = new ServletRequest(request);
        ServletResponse wsResponse = new ServletResponse(response);
        this.webServiceEngine.execute((Request)wsRequest, wsResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static Function<WebService.Action, String> toPath() {
        return action -> "/" + action.path() + "/*";
    }
}

