/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.ws.Response;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.utils.text.XmlWriter;

public class ServletResponse
implements Response {
    private final ServletStream stream;

    public ServletResponse(HttpServletResponse response) {
        this.stream = new ServletStream(response);
    }

    public JsonWriter newJsonWriter() {
        this.stream.setMediaType("application/json");
        return JsonWriter.of((Writer)new OutputStreamWriter(this.stream.output(), StandardCharsets.UTF_8));
    }

    public XmlWriter newXmlWriter() {
        this.stream.setMediaType("application/xml");
        return XmlWriter.of((Writer)new OutputStreamWriter(this.stream.output(), StandardCharsets.UTF_8));
    }

    public ServletStream stream() {
        return this.stream;
    }

    public Response noContent() {
        this.stream.setStatus(204);
        return this;
    }

    public Response setHeader(String name, String value) {
        this.stream.response().setHeader(name, value);
        return this;
    }

    public Collection<String> getHeaderNames() {
        return this.stream.response().getHeaderNames();
    }

    public String getHeader(String name) {
        return this.stream.response().getHeader(name);
    }

    public static class ServletStream
    implements Response.Stream {
        private final HttpServletResponse response;

        public ServletStream(HttpServletResponse response) {
            this.response = response;
            this.response.setStatus(200);
            this.response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        }

        public ServletStream setMediaType(String s) {
            this.response.setContentType(s);
            return this;
        }

        public ServletStream setStatus(int httpStatus) {
            this.response.setStatus(httpStatus);
            return this;
        }

        public OutputStream output() {
            try {
                return this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        HttpServletResponse response() {
            return this.response;
        }

        public ServletStream reset() {
            this.response.reset();
            return this;
        }
    }
}

