/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Response;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.utils.text.XmlWriter;

public class DefaultLocalResponse
implements Response,
LocalConnector.LocalResponse {
    private final InMemoryStream stream = new InMemoryStream();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private final Map<String, String> headers = Maps.newHashMap();

    public int getStatus() {
        return this.stream().status();
    }

    public String getMediaType() {
        return this.stream().mediaType();
    }

    public byte[] getBytes() {
        return this.output.toByteArray();
    }

    public JsonWriter newJsonWriter() {
        this.stream.setMediaType("application/json");
        return JsonWriter.of((Writer)new OutputStreamWriter((OutputStream)this.output, StandardCharsets.UTF_8));
    }

    public XmlWriter newXmlWriter() {
        this.stream.setMediaType("application/xml");
        return XmlWriter.of((Writer)new OutputStreamWriter((OutputStream)this.output, StandardCharsets.UTF_8));
    }

    public InMemoryStream stream() {
        return this.stream;
    }

    public Response noContent() {
        this.stream().setStatus(204);
        IOUtils.closeQuietly((OutputStream)this.output);
        return this;
    }

    public String outputAsString() {
        return new String(this.output.toByteArray(), StandardCharsets.UTF_8);
    }

    public Response setHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public byte[] getFlushedOutput() {
        try {
            this.output.flush();
            return this.output.toByteArray();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public class InMemoryStream
    implements Response.Stream {
        private String mediaType;
        private int status = 200;

        @CheckForNull
        public String mediaType() {
            return this.mediaType;
        }

        public int status() {
            return this.status;
        }

        public Response.Stream setMediaType(String s) {
            this.mediaType = s;
            return this;
        }

        public Response.Stream setStatus(int i) {
            this.status = i;
            return this;
        }

        public OutputStream output() {
            return DefaultLocalResponse.this.output;
        }
    }
}

