/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class QualityGate {
    private final String id;
    private final String name;
    private final Status status;
    private final Set<Condition> conditions;

    public QualityGate(String id, String name, Status status, Set<Condition> conditions) {
        this.id = Objects.requireNonNull(id, "id can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.status = Objects.requireNonNull(status, "status can't be null");
        this.conditions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(conditions, "conditions can't be null"));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Collection<Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualityGate that = (QualityGate)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.status == that.status && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.status, this.conditions});
    }

    public String toString() {
        return "QualityGate{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", conditions=" + this.conditions + '}';
    }

    public static enum EvaluationStatus {
        NO_VALUE,
        OK,
        WARN,
        ERROR;

    }

    public static enum Operator {
        EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }

    public static final class Condition {
        private final EvaluationStatus status;
        private final String metricKey;
        private final Operator operator;
        private final String errorThreshold;
        private final String warnThreshold;
        private final boolean onLeakPeriod;
        private final String value;

        public Condition(EvaluationStatus status, String metricKey, Operator operator, @Nullable String errorThreshold, @Nullable String warnThreshold, boolean onLeakPeriod, @Nullable String value) {
            this.status = Objects.requireNonNull(status, "status can't be null");
            this.metricKey = Objects.requireNonNull(metricKey, "metricKey can't be null");
            this.operator = Objects.requireNonNull(operator, "operator can't be null");
            this.errorThreshold = errorThreshold;
            this.warnThreshold = warnThreshold;
            this.onLeakPeriod = onLeakPeriod;
            this.value = value;
        }

        public EvaluationStatus getStatus() {
            return this.status;
        }

        public String getMetricKey() {
            return this.metricKey;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Optional<String> getErrorThreshold() {
            return Optional.ofNullable(this.errorThreshold);
        }

        public Optional<String> getWarningThreshold() {
            return Optional.ofNullable(this.warnThreshold);
        }

        public boolean isOnLeakPeriod() {
            return this.onLeakPeriod;
        }

        public Optional<String> getValue() {
            return Optional.ofNullable(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Condition condition = (Condition)o;
            return this.onLeakPeriod == condition.onLeakPeriod && this.status == condition.status && Objects.equals(this.metricKey, condition.metricKey) && this.operator == condition.operator && Objects.equals(this.errorThreshold, condition.errorThreshold) && Objects.equals(this.warnThreshold, condition.warnThreshold) && Objects.equals(this.value, condition.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.metricKey, this.operator, this.errorThreshold, this.warnThreshold, this.onLeakPeriod, this.value});
        }

        public String toString() {
            return "Condition{status=" + (Object)((Object)this.status) + ", metricKey='" + this.metricKey + '\'' + ", operator=" + (Object)((Object)this.operator) + ", errorThreshold='" + this.errorThreshold + '\'' + ", warnThreshold='" + this.warnThreshold + '\'' + ", onLeakPeriod=" + this.onLeakPeriod + ", value='" + this.value + '\'' + '}';
        }
    }

    public static enum Status {
        OK,
        WARN,
        ERROR;

    }
}

