/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.protobuf.Message;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.user.UserGroupValidation;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserMembershipQuery;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUserGroups;

public class UpdateAction
implements UserGroupsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport support;

    public UpdateAction(DbClient dbClient, UserSession userSession, GroupWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("update").setDescription("Update a group.<br>Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this).setPost(true).setResponseExample(this.getClass().getResource("update.example.json")).setSince("5.2").setChangelog(new Change[]{new Change("6.4", "The default group is no longer editable")});
        action.createParam("id").setDescription("Identifier of the group.").setExampleValue((Object)"42").setRequired(true);
        action.createParam("name").setDescription(String.format("New optional name for the group. A group name cannot be larger than %d characters and must be unique. Value 'anyone' (whatever the case) is reserved and cannot be used. If value is empty or not defined, then name is not changed.", 255)).setExampleValue((Object)"my-group");
        action.createParam("description").setDescription(String.format("New optional description for the group. A group description cannot be larger than %d characters. If value is not defined, then description is not changed.", 200)).setExampleValue((Object)"Default group for new users");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String description;
            int groupId = request.mandatoryParamAsInt("id");
            GroupDto group = this.dbClient.groupDao().selectById(dbSession, groupId);
            WsUtils.checkFound(group, "Could not find a user group with id '%s'.", groupId);
            Optional org = this.dbClient.organizationDao().selectByUuid(dbSession, group.getOrganizationUuid());
            WsUtils.checkFoundWithOptional(org, "Could not find organization with id '%s'.", group.getOrganizationUuid());
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, (OrganizationDto)org.get());
            this.support.checkGroupIsNotDefault(dbSession, group);
            boolean changed = false;
            String newName = request.param("name");
            if (newName != null) {
                changed = true;
                UserGroupValidation.validateGroupName((String)newName);
                this.support.checkNameDoesNotExist(dbSession, group.getOrganizationUuid(), newName);
                group.setName(newName);
            }
            if ((description = request.param("description")) != null) {
                changed = true;
                group.setDescription(this.support.validateDescription(description));
            }
            if (changed) {
                this.dbClient.groupDao().update(dbSession, group);
                dbSession.commit();
            }
            this.writeResponse(dbSession, request, response, (OrganizationDto)org.get(), group);
        }
    }

    private void writeResponse(DbSession dbSession, Request request, Response response, OrganizationDto organization, GroupDto group) {
        UserMembershipQuery query = UserMembershipQuery.builder().groupId(group.getId()).organizationUuid(organization.getUuid()).membership("IN").build();
        int membersCount = this.dbClient.groupMembershipDao().countMembers(dbSession, query);
        WsUserGroups.UpdateWsResponse.Builder respBuilder = WsUserGroups.UpdateWsResponse.newBuilder();
        respBuilder.setGroup(GroupWsSupport.toProtobuf(organization, group, membersCount, false));
        WsUtils.writeProtobuf((Message)respBuilder.build(), request, response);
    }
}

