/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.index;

import org.sonar.api.config.Configuration;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;

public class UserIndexDefinition
implements IndexDefinition {
    public static final IndexType INDEX_TYPE_USER = new IndexType("users", "user");
    public static final String FIELD_LOGIN = "login";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_SCM_ACCOUNTS = "scmAccounts";
    public static final String FIELD_ORGANIZATION_UUIDS = "organizationUuids";
    private final Configuration config;

    public UserIndexDefinition(Configuration config) {
        this.config = config;
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewIndex index = context.create(INDEX_TYPE_USER.getIndex(), NewIndex.SettingsConfiguration.newBuilder(this.config).setDefaultNbOfShards(1).build());
        NewIndex.NewIndexType mapping = index.createType(INDEX_TYPE_USER.getType());
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_LOGIN).addSubFields(DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_NAME).addSubFields(DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_EMAIL).addSubFields(DefaultIndexSettingsElement.USER_SEARCH_GRAMS_ANALYZER, DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        mapping.createBooleanField(FIELD_ACTIVE);
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_SCM_ACCOUNTS).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ORGANIZATION_UUIDS).disableNorms()).build();
    }
}

