/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.sonar.server.source.OpeningHtmlTag;

class DecorationDataHolder {
    private static final String ENTITY_SEPARATOR = ";";
    private static final String FIELD_SEPARATOR = ",";
    private static final String SYMBOL_PREFIX = "sym-";
    private static final String HIGHLIGHTABLE = "sym";
    private List<OpeningHtmlTag> openingTagsEntries = Lists.newArrayList();
    private int openingTagsIndex;
    private List<Integer> closingTagsOffsets = Lists.newArrayList();
    private int closingTagsIndex;

    DecorationDataHolder() {
    }

    void loadSymbolReferences(String symbolsReferences) {
        String[] symbols;
        for (String symbol : symbols = symbolsReferences.split(ENTITY_SEPARATOR)) {
            String[] symbolFields = symbol.split(FIELD_SEPARATOR);
            int declarationStartOffset = Integer.parseInt(symbolFields[0]);
            int declarationEndOffset = Integer.parseInt(symbolFields[1]);
            int symbolLength = declarationEndOffset - declarationStartOffset;
            String[] symbolOccurrences = Arrays.copyOfRange(symbolFields, 2, symbolFields.length);
            this.loadSymbolOccurrences(declarationStartOffset, symbolLength, symbolOccurrences);
        }
    }

    void loadLineSymbolReferences(String symbolsReferences) {
        String[] symbols;
        for (String symbol : symbols = symbolsReferences.split(ENTITY_SEPARATOR)) {
            String[] symbolFields = symbol.split(FIELD_SEPARATOR);
            int startOffset = Integer.parseInt(symbolFields[0]);
            int endOffset = Integer.parseInt(symbolFields[1]);
            int symbolLength = endOffset - startOffset;
            int symbolId = Integer.parseInt(symbolFields[2]);
            this.loadSymbolOccurrences(symbolId, symbolLength, new String[]{Integer.toString(startOffset)});
        }
    }

    void loadSyntaxHighlightingData(String syntaxHighlightingRules) {
        String[] rules;
        for (String rule : rules = syntaxHighlightingRules.split(ENTITY_SEPARATOR)) {
            int endOffset;
            String[] ruleFields = rule.split(FIELD_SEPARATOR);
            int startOffset = Integer.parseInt(ruleFields[0]);
            if (startOffset >= (endOffset = Integer.parseInt(ruleFields[1]))) continue;
            this.insertAndPreserveOrder(new OpeningHtmlTag(startOffset, ruleFields[2]), this.openingTagsEntries);
            this.insertAndPreserveOrder(endOffset, this.closingTagsOffsets);
        }
    }

    List<OpeningHtmlTag> getOpeningTagsEntries() {
        return this.openingTagsEntries;
    }

    OpeningHtmlTag getCurrentOpeningTagEntry() {
        return this.openingTagsIndex < this.openingTagsEntries.size() ? this.openingTagsEntries.get(this.openingTagsIndex) : null;
    }

    void nextOpeningTagEntry() {
        ++this.openingTagsIndex;
    }

    List<Integer> getClosingTagsOffsets() {
        return this.closingTagsOffsets;
    }

    int getCurrentClosingTagOffset() {
        return this.closingTagsIndex < this.closingTagsOffsets.size() ? this.closingTagsOffsets.get(this.closingTagsIndex) : -1;
    }

    void nextClosingTagOffset() {
        ++this.closingTagsIndex;
    }

    private void loadSymbolOccurrences(int declarationStartOffset, int symbolLength, String[] symbolOccurrences) {
        for (String symbolOccurrence : symbolOccurrences) {
            int occurrenceStartOffset = Integer.parseInt(symbolOccurrence);
            int occurrenceEndOffset = occurrenceStartOffset + symbolLength;
            this.insertAndPreserveOrder(new OpeningHtmlTag(occurrenceStartOffset, SYMBOL_PREFIX + declarationStartOffset + " " + HIGHLIGHTABLE), this.openingTagsEntries);
            this.insertAndPreserveOrder(occurrenceEndOffset, this.closingTagsOffsets);
        }
    }

    private void insertAndPreserveOrder(OpeningHtmlTag newEntry, List<OpeningHtmlTag> openingHtmlTags) {
        int insertionIndex = 0;
        Iterator<OpeningHtmlTag> tagIterator = openingHtmlTags.iterator();
        while (tagIterator.hasNext() && tagIterator.next().getStartOffset() <= newEntry.getStartOffset()) {
            ++insertionIndex;
        }
        openingHtmlTags.add(insertionIndex, newEntry);
    }

    private void insertAndPreserveOrder(int newOffset, List<Integer> orderedOffsets) {
        int insertionIndex = 0;
        Iterator<Integer> entriesIterator = orderedOffsets.iterator();
        while (entriesIterator.hasNext() && entriesIterator.next() <= newOffset) {
            ++insertionIndex;
        }
        orderedOffsets.add(insertionIndex, newOffset);
    }
}

