/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.rule.index.RuleIndexer;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.rule.ws.RulesWsAction;

public class DeleteAction
implements RulesWsAction {
    public static final String PARAM_KEY = "key";
    private final System2 system2;
    private final RuleIndexer ruleIndexer;
    private final DbClient dbClient;
    private final RuleActivator ruleActivator;
    private final RuleWsSupport ruleWsSupport;

    public DeleteAction(System2 system2, RuleIndexer ruleIndexer, DbClient dbClient, RuleActivator ruleActivator, RuleWsSupport ruleWsSupport) {
        this.system2 = system2;
        this.ruleIndexer = ruleIndexer;
        this.dbClient = dbClient;
        this.ruleActivator = ruleActivator;
        this.ruleWsSupport = ruleWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("delete").setDescription("Delete custom rule.<br/>Requires the 'Administer Quality Profiles' permission").setSince("4.4").setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setDescription("Rule key").setRequired(true).setExampleValue((Object)"squid:XPath_1402065390816");
    }

    public void handle(Request request, Response response) {
        this.ruleWsSupport.checkQProfileAdminPermissionOnDefaultOrganization();
        RuleKey key = RuleKey.parse((String)request.mandatoryParam(PARAM_KEY));
        this.delete(key);
    }

    public void delete(RuleKey ruleKey) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            RuleDefinitionDto rule = this.dbClient.ruleDao().selectOrFailDefinitionByKey(dbSession, ruleKey);
            Preconditions.checkArgument((boolean)rule.isCustomRule(), (String)"Rule '%s' cannot be deleted because it is not a custom rule", (Object[])new Object[]{rule.getKey().toString()});
            if (rule.isCustomRule()) {
                this.ruleActivator.delete(dbSession, rule);
            }
            rule.setStatus(RuleStatus.REMOVED);
            rule.setUpdatedAt(this.system2.now());
            this.dbClient.ruleDao().update(dbSession, rule);
            this.ruleIndexer.commitAndIndex(dbSession, ruleKey);
        }
    }
}

