/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;

class SearchData {
    private OrganizationDto organization;
    private List<QProfileDto> profiles;
    private Map<String, Long> activeRuleCountByProfileKey;
    private Map<String, Long> activeDeprecatedRuleCountByProfileKey;
    private Map<String, Long> projectCountByProfileKey;
    private Set<String> defaultProfileKeys;
    private Set<String> editableProfileKeys;
    private boolean isGlobalQProfileAdmin;

    SearchData() {
    }

    SearchData setOrganization(OrganizationDto organization) {
        this.organization = organization;
        return this;
    }

    OrganizationDto getOrganization() {
        return this.organization;
    }

    List<QProfileDto> getProfiles() {
        return this.profiles;
    }

    SearchData setProfiles(List<QProfileDto> profiles) {
        this.profiles = ImmutableList.copyOf(profiles);
        return this;
    }

    SearchData setActiveRuleCountByProfileKey(Map<String, Long> activeRuleCountByProfileKey) {
        this.activeRuleCountByProfileKey = ImmutableMap.copyOf(activeRuleCountByProfileKey);
        return this;
    }

    SearchData setActiveDeprecatedRuleCountByProfileKey(Map<String, Long> activeDeprecatedRuleCountByProfileKey) {
        this.activeDeprecatedRuleCountByProfileKey = activeDeprecatedRuleCountByProfileKey;
        return this;
    }

    SearchData setProjectCountByProfileKey(Map<String, Long> projectCountByProfileKey) {
        this.projectCountByProfileKey = ImmutableMap.copyOf(projectCountByProfileKey);
        return this;
    }

    long getActiveRuleCount(String profileKey) {
        return (Long)MoreObjects.firstNonNull((Object)this.activeRuleCountByProfileKey.get(profileKey), (Object)0L);
    }

    long getProjectCount(String profileKey) {
        return (Long)MoreObjects.firstNonNull((Object)this.projectCountByProfileKey.get(profileKey), (Object)0L);
    }

    long getActiveDeprecatedRuleCount(String profileKey) {
        return (Long)MoreObjects.firstNonNull((Object)this.activeDeprecatedRuleCountByProfileKey.get(profileKey), (Object)0L);
    }

    boolean isDefault(QProfileDto profile) {
        return this.defaultProfileKeys.contains(profile.getKee());
    }

    SearchData setDefaultProfileKeys(List<QProfileDto> s) {
        this.defaultProfileKeys = (Set)s.stream().map(QProfileDto::getKee).collect(MoreCollectors.toSet());
        return this;
    }

    boolean isEditable(QProfileDto profile) {
        return !profile.isBuiltIn() && (this.isGlobalQProfileAdmin || this.editableProfileKeys.contains(profile.getKee()));
    }

    SearchData setEditableProfileKeys(List<String> editableProfileKeys) {
        this.editableProfileKeys = new HashSet<String>(editableProfileKeys);
        return this;
    }

    boolean isGlobalQProfileAdmin() {
        return this.isGlobalQProfileAdmin;
    }

    SearchData setGlobalQProfileAdmin(boolean globalQProfileAdmin) {
        this.isGlobalQProfileAdmin = globalQProfileAdmin;
        return this;
    }
}

