/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class DeactivateRuleAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final RuleActivator ruleActivator;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public DeactivateRuleAction(DbClient dbClient, RuleActivator ruleActivator, UserSession userSession, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.ruleActivator = ruleActivator;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction deactivate = controller.createAction("deactivate_rule").setDescription("Deactivate a rule on a quality profile.<br> Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this).setPost(true).setSince("4.4");
        deactivate.createParam("key").setDescription("Quality Profile key. Can be obtained through <code>api/qualityprofiles/search</code>").setDeprecatedKey("profile_key", "6.5").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        deactivate.createParam("rule").setDescription("Rule key").setDeprecatedKey("rule_key", "6.5").setRequired(true).setExampleValue((Object)"squid:AvoidCycles");
    }

    public void handle(Request request, Response response) throws Exception {
        RuleKey ruleKey = RuleKey.parse((String)request.mandatoryParam("rule"));
        String qualityProfileKey = request.mandatoryParam("key");
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.wsSupport.getProfile(dbSession, QProfileReference.fromKey(qualityProfileKey));
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            this.ruleActivator.deactivateAndCommit(dbSession, profile, ruleKey);
        }
        response.noContent();
    }
}

