/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileUpdate;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;

public class BuiltInQProfileUpdateImpl
implements BuiltInQProfileUpdate {
    private final DbClient dbClient;
    private final RuleActivator ruleActivator;
    private final ActiveRuleIndexer activeRuleIndexer;

    public BuiltInQProfileUpdateImpl(DbClient dbClient, RuleActivator ruleActivator, ActiveRuleIndexer activeRuleIndexer) {
        this.dbClient = dbClient;
        this.ruleActivator = ruleActivator;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    @Override
    public List<ActiveRuleChange> update(DbSession dbSession, BuiltInQProfile builtIn, RulesProfileDto ruleProfile) {
        Set toBeDeactivated = (Set)this.dbClient.activeRuleDao().selectByRuleProfile(dbSession, ruleProfile).stream().map(ActiveRuleDto::getRuleKey).collect(MoreCollectors.toHashSet());
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        builtIn.getActiveRules().forEach(ar -> {
            RuleActivation activation = BuiltInQProfileUpdateImpl.convert(ar);
            toBeDeactivated.remove(activation.getRuleKey());
            changes.addAll(this.ruleActivator.activateOnBuiltInRulesProfile(dbSession, activation, ruleProfile));
        });
        toBeDeactivated.forEach(ruleKey -> changes.addAll(this.ruleActivator.deactivateOnBuiltInRulesProfile(dbSession, ruleProfile, (RuleKey)ruleKey, false)));
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    private static RuleActivation convert(BuiltInQualityProfilesDefinition.BuiltInActiveRule ar) {
        Map params = (Map)ar.overriddenParams().stream().collect(MoreCollectors.uniqueIndex(BuiltInQualityProfilesDefinition.OverriddenParam::key, BuiltInQualityProfilesDefinition.OverriddenParam::overriddenValue));
        return RuleActivation.create(RuleKey.of((String)ar.repoKey(), (String)ar.ruleKey()), ar.overriddenSeverity(), params);
    }
}

