/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.qualitygate.QualityGateUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsQualityGates;

public class CreateAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QualityGateUpdater qualityGateUpdater;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public CreateAction(DbClient dbClient, UserSession userSession, QualityGateUpdater qualityGateUpdater, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.qualityGateUpdater = qualityGateUpdater;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setDescription("Create a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("name").setDescription("The name of the quality gate to create").setRequired(true).setExampleValue((Object)"My Quality Gate");
    }

    public void handle(Request request, Response response) {
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, this.defaultOrganizationProvider.get().getUuid());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto newQualityGate = this.qualityGateUpdater.create(dbSession, request.mandatoryParam("name"));
            WsQualityGates.CreateWsResponse.Builder createWsResponse = WsQualityGates.CreateWsResponse.newBuilder().setId(newQualityGate.getId().longValue()).setName(newQualityGate.getName());
            dbSession.commit();
            WsUtils.writeProtobuf((Message)createWsResponse.build(), request, response);
        }
    }
}

