/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.utils.Paging;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.measure.MeasureQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.project.ws.SearchMyProjectsData;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.project.SearchMyProjectsRequest;

public class SearchMyProjectsDataLoader {
    private final UserSession userSession;
    private final DbClient dbClient;

    public SearchMyProjectsDataLoader(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    SearchMyProjectsData load(DbSession dbSession, SearchMyProjectsRequest request) {
        SearchMyProjectsData.Builder data = SearchMyProjectsData.builder();
        ProjectsResult searchResult = this.searchProjects(dbSession, request);
        List projects = searchResult.projects;
        List projectUuids = Lists.transform((List)projects, ComponentDto::projectUuid);
        List projectLinks = this.dbClient.componentLinkDao().selectByComponentUuids(dbSession, projectUuids);
        List snapshots = this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, (Collection)projectUuids);
        MetricDto gateStatusMetric = this.dbClient.metricDao().selectOrFailByKey(dbSession, "alert_status");
        MeasureQuery measureQuery = MeasureQuery.builder().setProjectUuids((Collection)projectUuids).setMetricId(gateStatusMetric.getId().intValue()).build();
        List qualityGates = this.dbClient.measureDao().selectByQuery(dbSession, measureQuery);
        data.setProjects(projects).setProjectLinks(projectLinks).setSnapshots(snapshots).setQualityGates(qualityGates).setTotalNbOfProjects(searchResult.total);
        return data.build();
    }

    @VisibleForTesting
    ProjectsResult searchProjects(DbSession dbSession, SearchMyProjectsRequest request) {
        int userId = Objects.requireNonNull(this.userSession.getUserId(), "Current user must be authenticated");
        List componentIds = this.dbClient.roleDao().selectComponentIdsByPermissionAndUserId(dbSession, "admin", userId);
        ComponentQuery dbQuery = ComponentQuery.builder().setQualifiers(new String[]{"TRK"}).setComponentIds((Set)ImmutableSet.copyOf(componentIds.subList(0, Math.min(componentIds.size(), 1000)))).build();
        return new ProjectsResult(this.dbClient.componentDao().selectByQuery(dbSession, dbQuery, Paging.offset((int)request.getPage(), (int)request.getPageSize()), request.getPageSize().intValue()), this.dbClient.componentDao().countByQuery(dbSession, dbQuery));
    }

    private static class ProjectsResult {
        private final List<ComponentDto> projects;
        private final int total;

        private ProjectsResult(List<ComponentDto> projects, int total) {
            this.projects = projects;
            this.total = total;
        }
    }
}

