/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.edition;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.PluginInfo;
import org.sonar.server.edition.License;
import org.sonar.server.edition.MutableEditionManagementState;
import org.sonar.server.plugins.ServerPluginRepository;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.edition.EditionBundledPlugins;
import org.sonar.server.plugins.edition.EditionInstallerExecutor;
import org.sonar.server.plugins.edition.EditionPluginDownloader;
import org.sonar.server.plugins.edition.EditionPluginUninstaller;
import org.sonar.updatecenter.common.UpdateCenter;

public class EditionInstaller {
    private static final Logger LOG = Loggers.get(EditionInstaller.class);
    private final Semaphore semaphore = new Semaphore(1);
    private final EditionInstallerExecutor executor;
    private final EditionPluginDownloader editionPluginDownloader;
    private final EditionPluginUninstaller editionPluginUninstaller;
    private final ServerPluginRepository pluginRepository;
    private final UpdateCenterMatrixFactory updateCenterMatrixFactory;
    private final MutableEditionManagementState editionManagementState;

    public EditionInstaller(EditionPluginDownloader editionDownloader, EditionPluginUninstaller editionPluginUninstaller, ServerPluginRepository pluginRepository, EditionInstallerExecutor executor, UpdateCenterMatrixFactory updateCenterMatrixFactory, MutableEditionManagementState editionManagementState) {
        this.editionPluginDownloader = editionDownloader;
        this.editionPluginUninstaller = editionPluginUninstaller;
        this.pluginRepository = pluginRepository;
        this.executor = executor;
        this.updateCenterMatrixFactory = updateCenterMatrixFactory;
        this.editionManagementState = editionManagementState;
    }

    public void install(License newLicense) {
        if (this.semaphore.tryAcquire()) {
            try {
                Optional<UpdateCenter> updateCenter = this.updateCenterMatrixFactory.getUpdateCenter(true);
                if (!updateCenter.isPresent()) {
                    LOG.info("Installation of edition '{}' needs to be done manually", (Object)newLicense.getEditionKey());
                    this.editionManagementState.startManualInstall(newLicense);
                    return;
                }
                this.editionManagementState.startAutomaticInstall(newLicense);
                this.executor.execute(() -> this.asyncInstall(newLicense, (UpdateCenter)updateCenter.get()));
            }
            catch (RuntimeException e) {
                this.semaphore.release();
                throw e;
            }
        } else {
            throw new IllegalStateException("Another installation of an edition is already running");
        }
    }

    public void uninstall() {
        Map<String, PluginInfo> pluginInfosByKeys = this.pluginRepository.getPluginInfosByKeys();
        Set<String> pluginsToRemove = EditionInstaller.pluginsToRemove(Collections.emptySet(), pluginInfosByKeys.values());
        this.uninstallPlugins(pluginsToRemove);
    }

    public boolean isOffline() {
        return !this.updateCenterMatrixFactory.getUpdateCenter(false).isPresent();
    }

    public boolean requiresInstallationChange(Set<String> editionPluginKeys) {
        Map<String, PluginInfo> pluginInfosByKeys = this.pluginRepository.getPluginInfosByKeys();
        return !EditionInstaller.pluginsToInstall(editionPluginKeys, pluginInfosByKeys.keySet()).isEmpty() || !EditionInstaller.pluginsToRemove(editionPluginKeys, pluginInfosByKeys.values()).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncInstall(License newLicense, UpdateCenter updateCenter) {
        try {
            Set<String> editionPluginKeys = newLicense.getPluginKeys();
            Map<String, PluginInfo> pluginInfosByKeys = this.pluginRepository.getPluginInfosByKeys();
            Set<String> pluginsToRemove = EditionInstaller.pluginsToRemove(editionPluginKeys, pluginInfosByKeys.values());
            Set<String> pluginsToInstall = EditionInstaller.pluginsToInstall(editionPluginKeys, pluginInfosByKeys.keySet());
            LOG.info("Installing edition '{}', download: {}, remove: {}", new Object[]{newLicense.getEditionKey(), pluginsToInstall, pluginsToRemove});
            this.editionPluginDownloader.downloadEditionPlugins(pluginsToInstall, updateCenter);
            this.uninstallPlugins(pluginsToRemove);
            this.editionManagementState.automaticInstallReady();
        }
        catch (Throwable t) {
            LOG.error("Failed to install edition {} with plugins {}", new Object[]{newLicense.getEditionKey(), newLicense.getPluginKeys(), t});
            this.editionManagementState.installFailed(t.getMessage());
        }
        finally {
            this.semaphore.release();
        }
    }

    private void uninstallPlugins(Set<String> pluginsToRemove) {
        pluginsToRemove.stream().forEach(this.editionPluginUninstaller::uninstall);
    }

    private static Set<String> pluginsToInstall(Set<String> editionPluginKeys, Set<String> installedPluginKeys) {
        return editionPluginKeys.stream().filter(p -> !installedPluginKeys.contains(p)).collect(Collectors.toSet());
    }

    private static Set<String> pluginsToRemove(Set<String> editionPluginKeys, Collection<PluginInfo> installedPluginInfos) {
        Set installedCommercialPluginKeys = installedPluginInfos.stream().filter(EditionBundledPlugins::isEditionBundled).map(PluginInfo::getKey).collect(Collectors.toSet());
        return installedCommercialPluginKeys.stream().filter(p -> !editionPluginKeys.contains(p)).collect(Collectors.toSet());
    }
}

