/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.serverid;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.ServerId;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.platform.WebServer;
import org.sonar.server.platform.serverid.ServerIdChecksum;
import org.sonar.server.platform.serverid.ServerIdFactory;

public class ServerIdManager
implements Startable {
    private static final Logger LOGGER = Loggers.get(ServerIdManager.class);
    private final ServerIdChecksum serverIdChecksum;
    private final ServerIdFactory serverIdFactory;
    private final DbClient dbClient;
    private final SonarRuntime runtime;
    private final WebServer webServer;

    public ServerIdManager(ServerIdChecksum serverIdChecksum, ServerIdFactory serverIdFactory, DbClient dbClient, SonarRuntime runtime, WebServer webServer) {
        this.serverIdChecksum = serverIdChecksum;
        this.serverIdFactory = serverIdFactory;
        this.dbClient = dbClient;
        this.runtime = runtime;
        this.webServer = webServer;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (this.runtime.getSonarQubeSide() == SonarQubeSide.SERVER && this.webServer.isStartupLeader()) {
                Optional checksum = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "server.idChecksum");
                ServerId serverId = this.readCurrentServerId(dbSession).map(currentServerId -> this.keepOrReplaceCurrentServerId(dbSession, (ServerId)currentServerId, checksum)).orElseGet(() -> this.createFirstServerId(dbSession));
                this.updateChecksum(dbSession, serverId);
                dbSession.commit();
            } else {
                this.ensureServerIdIsValid(dbSession);
            }
        }
    }

    private ServerId keepOrReplaceCurrentServerId(DbSession dbSession, ServerId currentServerId, Optional<String> checksum) {
        if (this.keepServerId(currentServerId, checksum)) {
            return currentServerId;
        }
        ServerId serverId = this.replaceCurrentServerId(currentServerId);
        this.persistServerId(dbSession, serverId);
        return serverId;
    }

    private boolean keepServerId(ServerId serverId, Optional<String> checksum) {
        String expectedChecksum;
        ServerId.Format format = serverId.getFormat();
        if (format == ServerId.Format.DEPRECATED || format == ServerId.Format.NO_DATABASE_ID) {
            LOGGER.info("Server ID is changed to new format.");
            return false;
        }
        if (checksum.isPresent() && !(expectedChecksum = this.serverIdChecksum.computeFor(serverId.toString())).equals(checksum.get())) {
            LOGGER.warn("Server ID is reset because it is not valid anymore. Database URL probably changed. The new server ID affects SonarSource licensed products.");
            return false;
        }
        return true;
    }

    private ServerId replaceCurrentServerId(ServerId currentServerId) {
        if (currentServerId.getFormat() == ServerId.Format.DEPRECATED) {
            return this.serverIdFactory.create();
        }
        return this.serverIdFactory.create(currentServerId);
    }

    private ServerId createFirstServerId(DbSession dbSession) {
        ServerId serverId = this.serverIdFactory.create();
        this.persistServerId(dbSession, serverId);
        return serverId;
    }

    private Optional<ServerId> readCurrentServerId(DbSession dbSession) {
        PropertyDto dto = this.dbClient.propertiesDao().selectGlobalProperty(dbSession, "sonar.core.id");
        if (dto == null) {
            return Optional.empty();
        }
        String value = dto.getValue();
        if (StringUtils.isEmpty((String)value)) {
            return Optional.empty();
        }
        return Optional.of(ServerId.parse((String)value));
    }

    private void updateChecksum(DbSession dbSession, ServerId serverId) {
        String checksum = this.serverIdChecksum.computeFor(serverId.toString());
        this.persistChecksum(dbSession, checksum);
    }

    private void persistServerId(DbSession dbSession, ServerId serverId) {
        this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey("sonar.core.id").setValue(serverId.toString()));
    }

    private void persistChecksum(DbSession dbSession, String checksump) {
        this.dbClient.internalPropertiesDao().save(dbSession, "server.idChecksum", checksump);
    }

    private void ensureServerIdIsValid(DbSession dbSession) {
        PropertyDto id = this.dbClient.propertiesDao().selectGlobalProperty(dbSession, "sonar.core.id");
        Preconditions.checkState((id != null ? 1 : 0) != 0, (String)"Property %s is missing in database", (Object[])new Object[]{"sonar.core.id"});
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)id.getValue()), (String)"Property %s is empty in database", (Object[])new Object[]{"sonar.core.id"});
        Optional checksum = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "server.idChecksum");
        Preconditions.checkState((boolean)checksum.isPresent(), (String)"Internal property %s is missing in database", (Object[])new Object[]{"server.idChecksum"});
        Preconditions.checkState((boolean)((String)checksum.get()).equals(this.serverIdChecksum.computeFor(id.getValue())), (Object)"Server ID is invalid");
    }

    public void stop() {
    }
}

