/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.serverid;

import com.google.common.annotations.VisibleForTesting;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.core.platform.ServerId;
import org.sonar.core.util.UuidFactory;
import org.sonar.server.platform.serverid.JdbcUrlSanitizer;
import org.sonar.server.platform.serverid.ServerIdFactory;

public class ServerIdFactoryImpl
implements ServerIdFactory {
    private final Configuration config;
    private final UuidFactory uuidFactory;
    private final JdbcUrlSanitizer jdbcUrlSanitizer;

    public ServerIdFactoryImpl(Configuration config, UuidFactory uuidFactory, JdbcUrlSanitizer jdbcUrlSanitizer) {
        this.config = config;
        this.uuidFactory = uuidFactory;
        this.jdbcUrlSanitizer = jdbcUrlSanitizer;
    }

    @Override
    public ServerId create() {
        return ServerId.of((String)this.computeDatabaseId(), (String)this.uuidFactory.create());
    }

    @Override
    public ServerId create(ServerId currentServerId) {
        return ServerId.of((String)this.computeDatabaseId(), (String)currentServerId.getDatasetId());
    }

    private String computeDatabaseId() {
        String jdbcUrl = (String)this.config.get("sonar.jdbc.url").orElseThrow(() -> new IllegalStateException("Missing JDBC URL"));
        return ServerIdFactoryImpl.crc32Hex(this.jdbcUrlSanitizer.sanitize(jdbcUrl));
    }

    @VisibleForTesting
    static String crc32Hex(String str) {
        CRC32 crc32 = new CRC32();
        crc32.update(str.getBytes(StandardCharsets.UTF_8));
        long hash = crc32.getValue();
        String s = Long.toHexString(hash).toUpperCase(Locale.ENGLISH);
        return StringUtils.leftPad((String)s, (int)8, (String)"0");
    }
}

