/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.serverid;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.KeyValueFormat;

public class JdbcUrlSanitizer {
    private static final String SQLSERVER_PREFIX = "jdbc:sqlserver://";

    public String sanitize(String jdbcUrl) {
        String result = jdbcUrl.startsWith(SQLSERVER_PREFIX) ? JdbcUrlSanitizer.sanitizeSqlServerUrl(jdbcUrl) : StringUtils.substringBefore((String)jdbcUrl, (String)"?");
        return StringUtils.lowerCase((String)result, (Locale)Locale.ENGLISH);
    }

    private static String sanitizeSqlServerUrl(String jdbcUrl) {
        StringBuilder result = new StringBuilder();
        result.append(SQLSERVER_PREFIX);
        String host = jdbcUrl.contains(";") ? StringUtils.substringBetween((String)jdbcUrl, (String)SQLSERVER_PREFIX, (String)";") : StringUtils.substringAfter((String)jdbcUrl, (String)SQLSERVER_PREFIX);
        String queryString = StringUtils.substringAfter((String)jdbcUrl, (String)";");
        Map parameters = KeyValueFormat.parse((String)queryString);
        Optional<String> server = JdbcUrlSanitizer.firstValue(parameters, "serverName", "servername", "server");
        if (server.isPresent()) {
            result.append(server.get());
        } else {
            result.append(StringUtils.substringBefore((String)host, (String)":"));
        }
        Optional<String> port = JdbcUrlSanitizer.firstValue(parameters, "portNumber", "port");
        if (port.isPresent()) {
            result.append(':').append(port.get());
        } else if (host.contains(":")) {
            result.append(':').append(StringUtils.substringAfter((String)host, (String)":"));
        }
        Optional<String> database = JdbcUrlSanitizer.firstValue(parameters, "databaseName", "database");
        database.ifPresent(s -> result.append('/').append((String)s));
        return result.toString();
    }

    private static Optional<String> firstValue(Map<String, String> map, String ... keys) {
        return Arrays.stream(keys).map(map::get).filter(Objects::nonNull).findFirst();
    }
}

