/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.WebServer;

public class WebServerImpl
implements WebServer {
    private final boolean clusterEnabled;
    private final boolean startupLeader;

    public WebServerImpl(Configuration config) {
        this.clusterEnabled = config.getBoolean("sonar.cluster.enabled").orElse(false);
        if (this.clusterEnabled) {
            this.startupLeader = config.getBoolean("sonar.cluster.web.startupLeader").orElse(false);
            Loggers.get(WebServerImpl.class).info("Cluster enabled (startup {})", (Object)(this.startupLeader ? "leader" : "follower"));
        } else {
            this.startupLeader = true;
        }
    }

    @Override
    public boolean isStandalone() {
        return !this.clusterEnabled;
    }

    @Override
    public boolean isStartupLeader() {
        return this.startupLeader;
    }
}

