/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.io.File;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.ServerFileSystem;

public class ServerFileSystemImpl
implements ServerFileSystem,
org.sonar.api.platform.ServerFileSystem,
Startable {
    private static final Logger LOGGER = Loggers.get(ServerFileSystemImpl.class);
    private final File homeDir;
    private final File tempDir;
    private final File dataDir;
    private final File deployDir;
    private final File uninstallDir;
    private final File editionUninstallDir;

    public ServerFileSystemImpl(Configuration config) {
        this.homeDir = new File((String)config.get("sonar.path.home").get());
        this.tempDir = new File((String)config.get("sonar.path.temp").get());
        this.dataDir = new File((String)config.get("sonar.path.data").get());
        this.deployDir = new File(this.dataDir, "web/deploy");
        this.uninstallDir = new File(this.getTempDir(), "uninstalled-plugins");
        this.editionUninstallDir = new File(this.getTempDir(), "uninstalled-edition-plugins");
    }

    public void start() {
        LOGGER.info("SonarQube home: " + this.homeDir.getAbsolutePath());
    }

    public void stop() {
    }

    @Override
    public File getHomeDir() {
        return this.homeDir;
    }

    @Override
    public File getTempDir() {
        return this.tempDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public File getDeployDir() {
        return this.deployDir;
    }

    @Override
    public File getDeployedPluginsDir() {
        return new File(this.getDeployDir(), "plugins");
    }

    @Override
    public File getDownloadedPluginsDir() {
        return new File(this.getHomeDir(), "extensions/downloads");
    }

    @Override
    public File getEditionDownloadedPluginsDir() {
        return new File(this.getHomeDir(), "extensions/new-edition");
    }

    @Override
    public File getInstalledPluginsDir() {
        return new File(this.getHomeDir(), "extensions/plugins");
    }

    @Override
    public File getBundledPluginsDir() {
        return new File(this.getHomeDir(), "lib/bundled-plugins");
    }

    @Override
    public File getPluginIndex() {
        return new File(this.getDeployDir(), "plugins/index.txt");
    }

    @Override
    public File getUninstalledPluginsDir() {
        return this.uninstallDir;
    }

    @Override
    public File getEditionUninstalledPluginsDir() {
        return this.editionUninstallDir;
    }
}

