/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.permission.template.PermissionTemplateUserDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsPermissions;

public class TemplateUsersAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionWsSupport support;

    public TemplateUsersAction(DbClient dbClient, UserSession userSession, PermissionWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("template_users").setSince("5.2").setDescription("Lists the users with their permission as individual users rather than through group affiliation on the chosen template. <br />This service defaults to all users, but can be limited to users with a specific permission by providing the desired permission.<br>Requires the following permission: 'Administer System'.").addPagingParams(20, 100).setInternal(true).setResponseExample(this.getClass().getResource("template_users-example.json")).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to user names that contain the supplied string. Must have at least %d characters.<br/>When this parameter is not set, only users having at least one permission are returned.", new Object[]{3}).setExampleValue((Object)"eri");
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action).setRequired(false);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            WsTemplateRef templateRef = WsTemplateRef.fromRequest(wsRequest);
            PermissionTemplateDto template = this.support.findTemplate(dbSession, templateRef);
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            PermissionQuery query = TemplateUsersAction.buildQuery(wsRequest, template);
            int total = this.dbClient.permissionTemplateDao().countUserLoginsByQueryAndTemplate(dbSession, query, template.getId().longValue());
            Paging paging = Paging.forPageIndex((int)wsRequest.mandatoryParamAsInt("p")).withPageSize(wsRequest.mandatoryParamAsInt("ps")).andTotal(total);
            List<UserDto> users = this.findUsers(dbSession, query, template);
            List permissionTemplateUsers = this.dbClient.permissionTemplateDao().selectUserPermissionsByTemplateIdAndUserLogins(dbSession, template.getId().longValue(), users.stream().map(UserDto::getLogin).collect(Collectors.toList()));
            WsPermissions.UsersWsResponse templateUsersResponse = TemplateUsersAction.buildResponse(users, permissionTemplateUsers, paging);
            WsUtils.writeProtobuf((Message)templateUsersResponse, wsRequest, wsResponse);
        }
    }

    private static PermissionQuery buildQuery(Request wsRequest, PermissionTemplateDto template) {
        String textQuery = wsRequest.param("q");
        String permission = wsRequest.param("permission");
        PermissionQuery.Builder query = PermissionQuery.builder().setOrganizationUuid(template.getOrganizationUuid()).setTemplate(template.getUuid()).setPermission(permission != null ? PermissionRequestValidator.validateProjectPermission(permission) : null).setPageIndex(Integer.valueOf(wsRequest.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(wsRequest.mandatoryParamAsInt("ps"))).setSearchQuery(textQuery);
        if (textQuery == null) {
            query.withAtLeastOnePermission();
        }
        return query.build();
    }

    private static WsPermissions.UsersWsResponse buildResponse(List<UserDto> users, List<PermissionTemplateUserDto> permissionTemplateUsers, Paging paging) {
        TreeMultimap permissionsByUserId = TreeMultimap.create();
        permissionTemplateUsers.forEach(arg_0 -> TemplateUsersAction.lambda$buildResponse$0((Multimap)permissionsByUserId, arg_0));
        WsPermissions.UsersWsResponse.Builder responseBuilder = WsPermissions.UsersWsResponse.newBuilder();
        users.forEach(arg_0 -> TemplateUsersAction.lambda$buildResponse$1(responseBuilder, (Multimap)permissionsByUserId, arg_0));
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        return responseBuilder.build();
    }

    private List<UserDto> findUsers(DbSession dbSession, PermissionQuery query, PermissionTemplateDto template) {
        List orderedLogins = this.dbClient.permissionTemplateDao().selectUserLoginsByQueryAndTemplate(dbSession, query, template.getId().longValue());
        return Ordering.explicit((List)orderedLogins).onResultOf(UserDto::getLogin).immutableSortedCopy((Iterable)this.dbClient.userDao().selectByLogins(dbSession, (Collection)orderedLogins));
    }

    private static /* synthetic */ void lambda$buildResponse$1(WsPermissions.UsersWsResponse.Builder responseBuilder, Multimap permissionsByUserId, UserDto user) {
        WsPermissions.User.Builder userResponse = responseBuilder.addUsersBuilder().setLogin(user.getLogin()).addAllPermissions((Iterable)permissionsByUserId.get((Object)user.getId()));
        Protobuf.setNullable((Object)user.getEmail(), arg_0 -> ((WsPermissions.User.Builder)userResponse).setEmail(arg_0));
        Protobuf.setNullable((Object)user.getName(), arg_0 -> ((WsPermissions.User.Builder)userResponse).setName(arg_0));
    }

    private static /* synthetic */ void lambda$buildResponse$0(Multimap permissionsByUserId, PermissionTemplateUserDto userPermission) {
        permissionsByUserId.put((Object)userPermission.getUserId(), (Object)userPermission.getPermission());
    }
}

