/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.List;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;

class SearchTemplatesData {
    private final List<PermissionTemplateDto> templates;
    private final DefaultTemplatesResolver.ResolvedDefaultTemplates defaultTemplates;
    private final Table<Long, String, Integer> userCountByTemplateIdAndPermission;
    private final Table<Long, String, Integer> groupCountByTemplateIdAndPermission;
    private final Table<Long, String, Boolean> withProjectCreatorByTemplateIdAndPermission;

    private SearchTemplatesData(Builder builder) {
        this.templates = ImmutableList.copyOf((Collection)builder.templates);
        this.defaultTemplates = builder.defaultTemplates;
        this.userCountByTemplateIdAndPermission = ImmutableTable.copyOf((Table)builder.userCountByTemplateIdAndPermission);
        this.groupCountByTemplateIdAndPermission = ImmutableTable.copyOf((Table)builder.groupCountByTemplateIdAndPermission);
        this.withProjectCreatorByTemplateIdAndPermission = ImmutableTable.copyOf((Table)builder.withProjectCreatorByTemplateIdAndPermission);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<PermissionTemplateDto> templates() {
        return this.templates;
    }

    public DefaultTemplatesResolver.ResolvedDefaultTemplates defaultTemplates() {
        return this.defaultTemplates;
    }

    public int userCount(long templateId, String permission) {
        return (Integer)MoreObjects.firstNonNull((Object)this.userCountByTemplateIdAndPermission.get((Object)templateId, (Object)permission), (Object)0);
    }

    public int groupCount(long templateId, String permission) {
        return (Integer)MoreObjects.firstNonNull((Object)this.groupCountByTemplateIdAndPermission.get((Object)templateId, (Object)permission), (Object)0);
    }

    public boolean withProjectCreator(long templateId, String permission) {
        return (Boolean)MoreObjects.firstNonNull((Object)this.withProjectCreatorByTemplateIdAndPermission.get((Object)templateId, (Object)permission), (Object)false);
    }

    public static class Builder {
        private List<PermissionTemplateDto> templates;
        private DefaultTemplatesResolver.ResolvedDefaultTemplates defaultTemplates;
        private Table<Long, String, Integer> userCountByTemplateIdAndPermission;
        private Table<Long, String, Integer> groupCountByTemplateIdAndPermission;
        private Table<Long, String, Boolean> withProjectCreatorByTemplateIdAndPermission;

        private Builder() {
        }

        public SearchTemplatesData build() {
            Preconditions.checkState((this.templates != null ? 1 : 0) != 0);
            Preconditions.checkState((this.defaultTemplates != null ? 1 : 0) != 0);
            Preconditions.checkState((this.userCountByTemplateIdAndPermission != null ? 1 : 0) != 0);
            Preconditions.checkState((this.groupCountByTemplateIdAndPermission != null ? 1 : 0) != 0);
            Preconditions.checkState((this.withProjectCreatorByTemplateIdAndPermission != null ? 1 : 0) != 0);
            return new SearchTemplatesData(this);
        }

        public Builder templates(List<PermissionTemplateDto> templates) {
            this.templates = templates;
            return this;
        }

        public Builder defaultTemplates(DefaultTemplatesResolver.ResolvedDefaultTemplates defaultTemplates) {
            this.defaultTemplates = defaultTemplates;
            return this;
        }

        public Builder userCountByTemplateIdAndPermission(Table<Long, String, Integer> userCountByTemplateIdAndPermission) {
            this.userCountByTemplateIdAndPermission = userCountByTemplateIdAndPermission;
            return this;
        }

        public Builder groupCountByTemplateIdAndPermission(Table<Long, String, Integer> groupCountByTemplateIdAndPermission) {
            this.groupCountByTemplateIdAndPermission = groupCountByTemplateIdAndPermission;
            return this;
        }

        public Builder withProjectCreatorByTemplateIdAndPermission(Table<Long, String, Boolean> withProjectCreatorByTemplateIdAndPermission) {
            this.withProjectCreatorByTemplateIdAndPermission = withProjectCreatorByTemplateIdAndPermission;
            return this;
        }
    }
}

