/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.protobuf.Message;
import java.util.Date;
import java.util.Locale;
import org.sonar.api.i18n.I18n;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;
import org.sonar.server.permission.ws.template.SearchTemplatesData;
import org.sonar.server.permission.ws.template.SearchTemplatesDataLoader;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsPermissions;
import org.sonarqube.ws.client.permission.SearchTemplatesWsRequest;

public class SearchTemplatesAction
implements PermissionsWsAction {
    private static final String PROPERTY_PREFIX = "projects_role.";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final I18n i18n;
    private final PermissionWsSupport support;
    private final SearchTemplatesDataLoader dataLoader;

    public SearchTemplatesAction(DbClient dbClient, UserSession userSession, I18n i18n, PermissionWsSupport support, SearchTemplatesDataLoader dataLoader) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.i18n = i18n;
        this.support = support;
        this.dataLoader = dataLoader;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_templates").setDescription("List permission templates.<br />Requires the following permission: 'Administer System'.").setResponseExample(this.getClass().getResource("search_templates-example.json")).setSince("5.2").addSearchQuery("defau", new String[]{"permission template names"}).setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createOrganizationParameter(action).setSince("6.2");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.support.findOrganization(dbSession, wsRequest.param("organization"));
            SearchTemplatesWsRequest request = new SearchTemplatesWsRequest().setOrganizationUuid(org.getUuid()).setQuery(wsRequest.param("q"));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, request.getOrganizationUuid());
            WsPermissions.SearchTemplatesWsResponse searchTemplatesWsResponse = this.buildResponse(this.dataLoader.load(dbSession, request));
            WsUtils.writeProtobuf((Message)searchTemplatesWsResponse, wsRequest, wsResponse);
        }
    }

    private static void buildDefaultTemplatesResponse(WsPermissions.SearchTemplatesWsResponse.Builder response, SearchTemplatesData data) {
        WsPermissions.SearchTemplatesWsResponse.TemplateIdQualifier.Builder templateUuidQualifierBuilder = WsPermissions.SearchTemplatesWsResponse.TemplateIdQualifier.newBuilder();
        DefaultTemplatesResolver.ResolvedDefaultTemplates resolvedDefaultTemplates = data.defaultTemplates();
        response.addDefaultTemplates(templateUuidQualifierBuilder.setQualifier("TRK").setTemplateId(resolvedDefaultTemplates.getProject()));
        resolvedDefaultTemplates.getView().ifPresent(viewDefaultTemplate -> response.addDefaultTemplates(templateUuidQualifierBuilder.clear().setQualifier("VW").setTemplateId(viewDefaultTemplate)));
    }

    private static void buildTemplatesResponse(WsPermissions.SearchTemplatesWsResponse.Builder response, SearchTemplatesData data) {
        WsPermissions.Permission.Builder permissionResponse = WsPermissions.Permission.newBuilder();
        WsPermissions.PermissionTemplate.Builder templateBuilder = WsPermissions.PermissionTemplate.newBuilder();
        for (PermissionTemplateDto templateDto : data.templates()) {
            templateBuilder.clear().setId(templateDto.getUuid()).setName(templateDto.getName()).setCreatedAt(DateUtils.formatDateTime((Date)templateDto.getCreatedAt())).setUpdatedAt(DateUtils.formatDateTime((Date)templateDto.getUpdatedAt()));
            Protobuf.setNullable((Object)templateDto.getKeyPattern(), arg_0 -> ((WsPermissions.PermissionTemplate.Builder)templateBuilder).setProjectKeyPattern(arg_0));
            Protobuf.setNullable((Object)templateDto.getDescription(), arg_0 -> ((WsPermissions.PermissionTemplate.Builder)templateBuilder).setDescription(arg_0));
            for (String permission : ProjectPermissions.ALL) {
                templateBuilder.addPermissions(permissionResponse.clear().setKey(permission).setUsersCount(data.userCount(templateDto.getId(), permission)).setGroupsCount(data.groupCount(templateDto.getId(), permission)).setWithProjectCreator(data.withProjectCreator(templateDto.getId(), permission)));
            }
            response.addPermissionTemplates(templateBuilder);
        }
    }

    private WsPermissions.SearchTemplatesWsResponse buildResponse(SearchTemplatesData data) {
        WsPermissions.SearchTemplatesWsResponse.Builder response = WsPermissions.SearchTemplatesWsResponse.newBuilder();
        SearchTemplatesAction.buildTemplatesResponse(response, data);
        SearchTemplatesAction.buildDefaultTemplatesResponse(response, data);
        this.buildPermissionsResponse(response);
        return response.build();
    }

    private void buildPermissionsResponse(WsPermissions.SearchTemplatesWsResponse.Builder response) {
        WsPermissions.Permission.Builder permissionResponse = WsPermissions.Permission.newBuilder();
        for (String permissionKey : ProjectPermissions.ALL) {
            response.addPermissions(permissionResponse.clear().setKey(permissionKey).setName(this.i18nName(permissionKey)).setDescription(this.i18nDescriptionMessage(permissionKey)));
        }
    }

    private String i18nDescriptionMessage(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey + DESCRIPTION_SUFFIX, "", new Object[0]);
    }

    private String i18nName(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey, permissionKey, new Object[0]);
    }
}

