/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.project.Visibility;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class UpdateProjectVisibilityAction
implements OrganizationsWsAction {
    static final String ACTION = "update_project_visibility";
    static final String PARAM_PROJECT_VISIBILITY = "projectVisibility";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final BillingValidationsProxy billingValidations;

    public UpdateProjectVisibilityAction(UserSession userSession, DbClient dbClient, BillingValidationsProxy billingValidations) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.billingValidations = billingValidations;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Update the default visibility for new projects of the specified organization.").setInternal(true).setSince("6.4").setHandler((RequestHandler)this);
        action.createParam("organization").setRequired(true).setDescription("Organization key").setExampleValue((Object)"foo-company");
        action.createParam(PARAM_PROJECT_VISIBILITY).setRequired(true).setDescription("Default visibility for projects").setPossibleValues(Visibility.getLabels());
    }

    public void handle(Request request, Response response) throws Exception {
        String organizationKey = request.mandatoryParam("organization");
        boolean newProjectsPrivate = Visibility.isPrivate(request.mandatoryParam(PARAM_PROJECT_VISIBILITY));
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional optionalOrganization = this.dbClient.organizationDao().selectByKey(dbSession, organizationKey);
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(optionalOrganization, "No organization with key '" + organizationKey + "' can be found.", new Object[0]);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization.getUuid());
            this.checkCanUpdateProjectsVisibility(organization, newProjectsPrivate);
            this.dbClient.organizationDao().setNewProjectPrivate(dbSession, organization, newProjectsPrivate);
            dbSession.commit();
        }
        response.noContent();
    }

    private void checkCanUpdateProjectsVisibility(OrganizationDto organization, boolean newProjectsPrivate) {
        try {
            this.billingValidations.checkCanUpdateProjectVisibility(new BillingValidations.Organization(organization.getKey(), organization.getUuid()), newProjectsPrivate);
        }
        catch (BillingValidations.BillingValidationsException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

