/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.user.UserSession;

public class SearchMyOrganizationsAction
implements OrganizationsWsAction {
    private static final String ACTION = "search_my_organizations";
    private final UserSession userSession;
    private final DbClient dbClient;

    public SearchMyOrganizationsAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        context.createAction(ACTION).setPost(false).setDescription("List keys of the organizations for which the currently authenticated user has the System Administer permission for.").setResponseExample(this.getClass().getResource("search_my_organization-example.json")).setInternal(true).setSince("6.3").setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        if (!this.userSession.isLoggedIn()) {
            response.noContent();
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            json.name("organizations").beginArray();
            this.dbClient.organizationDao().selectByPermission(dbSession, this.userSession.getUserId(), OrganizationPermission.ADMINISTER.getKey()).forEach(dto -> json.value(dto.getKey()));
            json.endArray();
            json.endObject();
            json.close();
        }
    }
}

