/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.Slug;
import org.sonar.server.organization.OrganizationValidation;

public class OrganizationValidationImpl
implements OrganizationValidation {
    @Override
    public String checkKey(String keyCandidate) {
        Objects.requireNonNull(keyCandidate, "key can't be null");
        Preconditions.checkArgument((keyCandidate.length() >= 2 ? 1 : 0) != 0, (String)"Key '%s' must be at least %s chars long", (Object[])new Object[]{keyCandidate, 2});
        Preconditions.checkArgument((keyCandidate.length() <= 32 ? 1 : 0) != 0, (String)"Key '%s' must be at most %s chars long", (Object[])new Object[]{keyCandidate, 32});
        Preconditions.checkArgument((boolean)Slug.slugify((String)keyCandidate).equals(keyCandidate), (String)"Key '%s' contains at least one invalid char", (Object[])new Object[]{keyCandidate});
        return keyCandidate;
    }

    @Override
    public String checkName(String nameCandidate) {
        Objects.requireNonNull(nameCandidate, "name can't be null");
        Preconditions.checkArgument((nameCandidate.length() >= 2 ? 1 : 0) != 0, (String)"Name '%s' must be at least %s chars long", (Object[])new Object[]{nameCandidate, 2});
        Preconditions.checkArgument((nameCandidate.length() <= 64 ? 1 : 0) != 0, (String)"Name '%s' must be at most %s chars long", (Object[])new Object[]{nameCandidate, 64});
        return nameCandidate;
    }

    @Override
    public String checkDescription(@Nullable String descriptionCandidate) {
        OrganizationValidationImpl.checkParamMaxLength(descriptionCandidate, "Description", 256);
        return descriptionCandidate;
    }

    @Override
    public String checkUrl(@Nullable String urlCandidate) {
        OrganizationValidationImpl.checkParamMaxLength(urlCandidate, "Url", 256);
        return urlCandidate;
    }

    @Override
    public String checkAvatar(@Nullable String avatarCandidate) {
        OrganizationValidationImpl.checkParamMaxLength(avatarCandidate, "Avatar", 256);
        return avatarCandidate;
    }

    @CheckForNull
    private static void checkParamMaxLength(@Nullable String value, String label, int maxLength) {
        if (value != null) {
            Preconditions.checkArgument((value.length() <= maxLength ? 1 : 0) != 0, (String)"%s '%s' must be at most %s chars long", (Object[])new Object[]{label, value, maxLength});
        }
    }

    @Override
    public String generateKeyFrom(String source) {
        return Slug.slugify((String)source.substring(0, Math.min(source.length(), 32)));
    }
}

