/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationCache;
import org.sonar.server.organization.DefaultOrganizationProvider;

public class DefaultOrganizationProviderImpl
implements DefaultOrganizationProvider,
DefaultOrganizationCache {
    private static final ThreadLocal<Cache> CACHE = new ThreadLocal();
    private final DbClient dbClient;

    public DefaultOrganizationProviderImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public DefaultOrganization get() {
        Cache cache = CACHE.get();
        if (cache != null) {
            return cache.get(() -> DefaultOrganizationProviderImpl.getDefaultOrganization(this.dbClient));
        }
        return DefaultOrganizationProviderImpl.getDefaultOrganization(this.dbClient);
    }

    private static DefaultOrganization getDefaultOrganization(DbClient dbClient) {
        try (DbSession dbSession = dbClient.openSession(false);){
            Optional uuid = dbClient.internalPropertiesDao().selectByKey(dbSession, "organization.default");
            Preconditions.checkState((uuid.isPresent() && !((String)uuid.get()).isEmpty() ? 1 : 0) != 0, (Object)"No Default organization uuid configured");
            Optional dto = dbClient.organizationDao().selectByUuid(dbSession, (String)uuid.get());
            Preconditions.checkState((boolean)dto.isPresent(), (String)"Default organization with uuid '%s' does not exist", (Object[])new Object[]{uuid.get()});
            DefaultOrganization defaultOrganization = DefaultOrganizationProviderImpl.toDefaultOrganization((OrganizationDto)dto.get());
            return defaultOrganization;
        }
    }

    private static DefaultOrganization toDefaultOrganization(OrganizationDto organizationDto) {
        return DefaultOrganization.newBuilder().setUuid(organizationDto.getUuid()).setKey(organizationDto.getKey()).setName(organizationDto.getName()).setCreatedAt(organizationDto.getCreatedAt()).setUpdatedAt(organizationDto.getUpdatedAt()).build();
    }

    @Override
    public void load() {
        Preconditions.checkState((CACHE.get() == null ? 1 : 0) != 0, (String)"load called twice for thread '%s' or state wasn't cleared last time it was used", (Object[])new Object[]{Thread.currentThread().getName()});
        CACHE.set(new Cache());
    }

    @Override
    public void unload() {
        CACHE.remove();
    }

    private static final class Cache {
        @CheckForNull
        private DefaultOrganization defaultOrganization;

        private Cache() {
        }

        public DefaultOrganization get(Supplier<DefaultOrganization> supplier) {
            if (this.defaultOrganization == null) {
                this.defaultOrganization = supplier.get();
            }
            return this.defaultOrganization;
        }
    }
}

