/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.email;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.user.User;
import org.sonar.api.user.UserFinder;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.emailnotifications.api.EmailMessage;
import org.sonar.plugins.emailnotifications.api.EmailTemplate;

public class EmailNotificationChannel
extends NotificationChannel {
    private static final Logger LOG = Loggers.get(EmailNotificationChannel.class);
    private static final int SOCKET_TIMEOUT = 30000;
    private static final String LIST_ID_HEADER = "List-ID";
    private static final String LIST_ARCHIVE_HEADER = "List-Archive";
    private static final String IN_REPLY_TO_HEADER = "In-Reply-To";
    private static final String REFERENCES_HEADER = "References";
    private static final String SUBJECT_DEFAULT = "Notification";
    private EmailSettings configuration;
    private EmailTemplate[] templates;
    private UserFinder userFinder;

    public EmailNotificationChannel(EmailSettings configuration, EmailTemplate[] templates, UserFinder userFinder) {
        this.configuration = configuration;
        this.templates = templates;
        this.userFinder = userFinder;
    }

    public boolean deliver(Notification notification, String username) {
        User user = this.userFinder.findByLogin(username);
        if (user == null || StringUtils.isBlank((String)user.email())) {
            LOG.debug("User does not exist or has no email: {}", (Object)username);
            return false;
        }
        EmailMessage emailMessage = this.format(notification);
        if (emailMessage != null) {
            emailMessage.setTo(user.email());
            return this.deliver(emailMessage);
        }
        return false;
    }

    private EmailMessage format(Notification notification) {
        for (EmailTemplate template : this.templates) {
            EmailMessage email = template.format(notification);
            if (email == null) continue;
            return email;
        }
        LOG.warn("Email template not found for notification: {}", (Object)notification);
        return null;
    }

    boolean deliver(EmailMessage emailMessage) {
        if (StringUtils.isBlank((String)this.configuration.getSmtpHost())) {
            LOG.debug("SMTP host was not configured - email will not be sent");
            return false;
        }
        try {
            this.send(emailMessage);
            return true;
        }
        catch (EmailException e) {
            LOG.error("Unable to send email", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(EmailMessage emailMessage) throws EmailException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            LOG.trace("Sending email: {}", (Object)emailMessage);
            String host = null;
            try {
                host = new URL(this.configuration.getServerBaseURL()).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            SimpleEmail email = new SimpleEmail();
            if (StringUtils.isNotBlank((String)host)) {
                if (StringUtils.isNotEmpty((String)emailMessage.getMessageId())) {
                    String messageId = "<" + emailMessage.getMessageId() + "@" + host + ">";
                    email.addHeader(IN_REPLY_TO_HEADER, messageId);
                    email.addHeader(REFERENCES_HEADER, messageId);
                }
                email.addHeader(LIST_ID_HEADER, "SonarQube <sonar." + host + ">");
                email.addHeader(LIST_ARCHIVE_HEADER, this.configuration.getServerBaseURL());
            }
            email.setCharset("UTF-8");
            String fromName = this.configuration.getFromName();
            String from = StringUtils.isBlank((String)emailMessage.getFrom()) ? fromName : emailMessage.getFrom() + " (" + fromName + ")";
            email.setFrom(this.configuration.getFrom(), from);
            email.addTo(emailMessage.getTo(), " ");
            String subject = StringUtils.defaultIfBlank((String)(StringUtils.trimToEmpty((String)this.configuration.getPrefix()) + " "), (String)"") + StringUtils.defaultString((String)emailMessage.getSubject(), (String)SUBJECT_DEFAULT);
            email.setSubject(subject);
            email.setMsg(emailMessage.getMessage());
            email.setHostName(this.configuration.getSmtpHost());
            this.configureSecureConnection(email);
            if (StringUtils.isNotBlank((String)this.configuration.getSmtpUsername()) || StringUtils.isNotBlank((String)this.configuration.getSmtpPassword())) {
                email.setAuthentication(this.configuration.getSmtpUsername(), this.configuration.getSmtpPassword());
            }
            email.setSocketConnectionTimeout(30000);
            email.setSocketTimeout(30000);
            email.send();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private void configureSecureConnection(SimpleEmail email) {
        if (StringUtils.equalsIgnoreCase((String)this.configuration.getSecureConnection(), (String)"ssl")) {
            email.setSSLOnConnect(true);
            email.setSSLCheckServerIdentity(true);
            email.setSslSmtpPort(String.valueOf(this.configuration.getSmtpPort()));
            email.setSmtpPort(this.configuration.getSmtpPort());
        } else if (StringUtils.equalsIgnoreCase((String)this.configuration.getSecureConnection(), (String)"starttls")) {
            email.setStartTLSEnabled(true);
            email.setStartTLSRequired(true);
            email.setSSLCheckServerIdentity(true);
            email.setSmtpPort(this.configuration.getSmtpPort());
        } else if (StringUtils.isBlank((String)this.configuration.getSecureConnection())) {
            email.setSmtpPort(this.configuration.getSmtpPort());
        } else {
            throw new SonarException("Unknown type of SMTP secure connection: " + this.configuration.getSecureConnection());
        }
    }

    public void sendTestEmail(String toAddress, String subject, String message) throws EmailException {
        try {
            EmailMessage emailMessage = new EmailMessage();
            emailMessage.setTo(toAddress);
            emailMessage.setSubject(subject);
            emailMessage.setMessage(message);
            this.send(emailMessage);
        }
        catch (EmailException e) {
            LOG.debug("Fail to send test email to {}: {}", (Object)toAddress, (Object)e);
            throw e;
        }
    }
}

