/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureDtoToWsMeasure;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.MeasuresWsParametersBuilder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsMeasures;
import org.sonarqube.ws.client.measure.SearchRequest;

public class SearchAction
implements MeasuresWsAction {
    private static final Set<String> ALLOWED_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"APP", (Object)"VW", (Object)"SVW");
    private final UserSession userSession;
    private final DbClient dbClient;

    public SearchAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setInternal(true).setDescription("Search for project measures ordered by project names.<br>At most %d projects can be provided.<br>Returns the projects with the 'Browse' permission.", new Object[]{100}).setSince("6.2").setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
        MeasuresWsParametersBuilder.createMetricKeysParameter(action);
        action.createParam("projectKeys").setDescription("Comma-separated list of project, view or sub-view keys").setExampleValue((Object)String.join((CharSequence)",", "my_project", "another_project")).setRequired(true);
    }

    public void handle(Request httpRequest, Response httpResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            WsMeasures.SearchWsResponse response = new ResponseBuilder(httpRequest, dbSession).build();
            WsUtils.writeProtobuf((Message)response, httpRequest, httpResponse);
        }
    }

    private class ResponseBuilder {
        private final DbSession dbSession;
        private final Request httpRequest;
        private SearchRequest request;
        private List<ComponentDto> projects;
        private List<MetricDto> metrics;
        private List<MeasureDto> measures;

        ResponseBuilder(Request httpRequest, DbSession dbSession) {
            this.dbSession = dbSession;
            this.httpRequest = httpRequest;
        }

        WsMeasures.SearchWsResponse build() {
            this.request = this.createRequest();
            this.projects = this.searchProjects();
            this.metrics = this.searchMetrics();
            this.measures = this.searchMeasures();
            return this.buildResponse();
        }

        private SearchRequest createRequest() {
            this.request = SearchRequest.builder().setMetricKeys(this.httpRequest.mandatoryParamAsStrings("metricKeys")).setProjectKeys(this.httpRequest.paramAsStrings("projectKeys")).build();
            return this.request;
        }

        private List<ComponentDto> searchProjects() {
            List<ComponentDto> componentDtos = this.searchByProjectKeys(this.dbSession, this.request.getProjectKeys());
            Preconditions.checkArgument((boolean)ALLOWED_QUALIFIERS.containsAll((Collection)componentDtos.stream().map(ComponentDto::qualifier).collect(MoreCollectors.toSet())), (String)"Only component of qualifiers %s are allowed", (Object[])new Object[]{ALLOWED_QUALIFIERS});
            return this.getAuthorizedProjects(componentDtos);
        }

        private List<ComponentDto> searchByProjectKeys(DbSession dbSession, List<String> projectKeys) {
            return SearchAction.this.dbClient.componentDao().selectByKeys(dbSession, projectKeys);
        }

        private List<ComponentDto> getAuthorizedProjects(List<ComponentDto> componentDtos) {
            return SearchAction.this.userSession.keepAuthorizedComponents("user", componentDtos);
        }

        private List<MetricDto> searchMetrics() {
            List dbMetrics = SearchAction.this.dbClient.metricDao().selectByKeys(this.dbSession, this.request.getMetricKeys());
            List metricKeys = (List)dbMetrics.stream().map(MetricDto::getKey).collect(MoreCollectors.toList());
            WsUtils.checkRequest(this.request.getMetricKeys().size() == dbMetrics.size(), "The following metrics are not found: %s", String.join((CharSequence)", ", this.difference(this.request.getMetricKeys(), metricKeys)));
            return dbMetrics;
        }

        private List<String> difference(Collection<String> expected, Collection<String> actual) {
            HashSet<String> actualSet = new HashSet<String>(actual);
            return (List)expected.stream().filter(value -> !actualSet.contains(value)).sorted(String::compareTo).collect(MoreCollectors.toList());
        }

        private List<MeasureDto> searchMeasures() {
            return SearchAction.this.dbClient.measureDao().selectByComponentsAndMetrics(this.dbSession, (Collection)this.projects.stream().map(ComponentDto::uuid).collect(MoreCollectors.toList()), (Collection)this.metrics.stream().map(MetricDto::getId).collect(MoreCollectors.toList()));
        }

        private WsMeasures.SearchWsResponse buildResponse() {
            List<WsMeasures.Measure> wsMeasures = this.buildWsMeasures();
            return WsMeasures.SearchWsResponse.newBuilder().addAllMeasures(wsMeasures).build();
        }

        private List<WsMeasures.Measure> buildWsMeasures() {
            Map componentsByUuid = this.projects.stream().collect(Collectors.toMap(ComponentDto::uuid, Function.identity()));
            Map<String, String> componentNamesByKey = this.projects.stream().collect(Collectors.toMap(ComponentDto::getDbKey, ComponentDto::name));
            Map metricsById = this.metrics.stream().collect(Collectors.toMap(MetricDto::getId, Function.identity()));
            Function<MeasureDto, MetricDto> dbMeasureToDbMetric = dbMeasure -> (MetricDto)metricsById.get(dbMeasure.getMetricId());
            Function<WsMeasures.Measure, String> byMetricKey = WsMeasures.Measure::getMetric;
            Function<WsMeasures.Measure, String> byComponentName = wsMeasure -> (String)componentNamesByKey.get(wsMeasure.getComponent());
            WsMeasures.Measure.Builder measureBuilder = WsMeasures.Measure.newBuilder();
            return (List)this.measures.stream().map(dbMeasure -> {
                MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, (MetricDto)dbMeasureToDbMetric.apply((MeasureDto)dbMeasure), dbMeasure);
                measureBuilder.setComponent(((ComponentDto)componentsByUuid.get(dbMeasure.getComponentUuid())).getDbKey());
                WsMeasures.Measure measure = measureBuilder.build();
                measureBuilder.clear();
                return measure;
            }).sorted(Comparator.comparing(byMetricKey).thenComparing(byComponentName)).collect(MoreCollectors.toList());
        }
    }
}

