/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.webhook;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.search.SearchResponse;
import org.sonar.api.config.Configuration;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.AnalysisPropertyDto;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.es.Facets;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.issue.IssueQuery;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.webhook.IssueChangeWebhook;
import org.sonar.server.qualitygate.ShortLivingBranchQualityGate;
import org.sonar.server.settings.ProjectConfigurationLoader;
import org.sonar.server.webhook.Analysis;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.Project;
import org.sonar.server.webhook.ProjectAnalysis;
import org.sonar.server.webhook.QualityGate;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.WebhookPayload;
import org.sonar.server.webhook.WebhookPayloadFactory;

public class IssueChangeWebhookImpl
implements IssueChangeWebhook {
    private static final Set<String> MEANINGFUL_TRANSITIONS = ImmutableSet.of((Object)"resolve", (Object)"falsepositive", (Object)"wontfix", (Object)"reopen");
    private final DbClient dbClient;
    private final WebHooks webhooks;
    private final ProjectConfigurationLoader projectConfigurationLoader;
    private final WebhookPayloadFactory webhookPayloadFactory;
    private final IssueIndex issueIndex;
    private final System2 system2;

    public IssueChangeWebhookImpl(DbClient dbClient, WebHooks webhooks, ProjectConfigurationLoader projectConfigurationLoader, WebhookPayloadFactory webhookPayloadFactory, IssueIndex issueIndex, System2 system2) {
        this.dbClient = dbClient;
        this.webhooks = webhooks;
        this.projectConfigurationLoader = projectConfigurationLoader;
        this.webhookPayloadFactory = webhookPayloadFactory;
        this.issueIndex = issueIndex;
        this.system2 = system2;
    }

    @Override
    public void onChange(IssueChangeWebhook.IssueChangeData issueChangeData, IssueChangeWebhook.IssueChange issueChange, IssueChangeContext context) {
        if (IssueChangeWebhookImpl.isEmpty(issueChangeData) || !IssueChangeWebhookImpl.isUserChangeContext(context) || !IssueChangeWebhookImpl.isRelevant(issueChange)) {
            return;
        }
        this.callWebHook(issueChangeData);
    }

    private static boolean isRelevant(IssueChangeWebhook.IssueChange issueChange) {
        return issueChange.getTransitionKey().map(IssueChangeWebhookImpl::isMeaningfulTransition).orElse(true);
    }

    private static boolean isEmpty(IssueChangeWebhook.IssueChangeData issueChangeData) {
        return issueChangeData.getIssues().isEmpty();
    }

    private static boolean isUserChangeContext(IssueChangeContext context) {
        return context.login() != null;
    }

    private static boolean isMeaningfulTransition(String transitionKey) {
        return MEANINGFUL_TRANSITIONS.contains(transitionKey);
    }

    private void callWebHook(IssueChangeWebhook.IssueChangeData issueChangeData) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map<String, ComponentDto> branchesByUuid = this.getBranchComponents(dbSession, issueChangeData);
            if (branchesByUuid.isEmpty()) {
                return;
            }
            Set branchProjectUuids = (Set)branchesByUuid.values().stream().map(ComponentDto::uuid).collect(MoreCollectors.toSet((int)branchesByUuid.size()));
            Set shortBranches = (Set)this.dbClient.branchDao().selectByUuids(dbSession, (Collection)branchProjectUuids).stream().filter(branchDto -> branchDto.getBranchType() == BranchType.SHORT).collect(MoreCollectors.toSet((int)branchesByUuid.size()));
            if (shortBranches.isEmpty()) {
                return;
            }
            Map<String, Configuration> configurationByUuid = this.projectConfigurationLoader.loadProjectConfigurations(dbSession, shortBranches.stream().map(shortBranch -> (ComponentDto)branchesByUuid.get(shortBranch.getUuid())).collect(Collectors.toSet()));
            Set branchesWithWebhooks = (Set)shortBranches.stream().filter(shortBranch -> this.webhooks.isEnabled((Configuration)configurationByUuid.get(shortBranch.getUuid()))).collect(MoreCollectors.toSet());
            if (branchesWithWebhooks.isEmpty()) {
                return;
            }
            Map analysisByProjectUuid = (Map)this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, (Collection)branchesWithWebhooks.stream().map(BranchDto::getUuid).collect(MoreCollectors.toSet((int)shortBranches.size()))).stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getComponentUuid));
            branchesWithWebhooks.forEach(shortBranch -> {
                ComponentDto branch = (ComponentDto)branchesByUuid.get(shortBranch.getUuid());
                SnapshotDto analysis = (SnapshotDto)analysisByProjectUuid.get(shortBranch.getUuid());
                if (branch != null && analysis != null) {
                    this.webhooks.sendProjectAnalysisUpdate((Configuration)configurationByUuid.get(shortBranch.getUuid()), new WebHooks.Analysis(shortBranch.getUuid(), analysis.getUuid(), null), () -> this.buildWebHookPayload(dbSession, branch, (BranchDto)shortBranch, analysis));
                }
            });
        }
    }

    private WebhookPayload buildWebHookPayload(DbSession dbSession, ComponentDto branch, BranchDto shortBranch, SnapshotDto analysis) {
        Map<String, String> analysisProperties = this.dbClient.analysisPropertiesDao().selectBySnapshotUuid(dbSession, analysis.getUuid()).stream().collect(Collectors.toMap(AnalysisPropertyDto::getKey, AnalysisPropertyDto::getValue));
        ProjectAnalysis projectAnalysis = new ProjectAnalysis(new Project(branch.getMainBranchProjectUuid(), branch.getKey(), branch.name()), null, new Analysis(analysis.getUuid(), analysis.getCreatedAt()), new Branch(false, shortBranch.getKey(), Branch.Type.SHORT), this.createQualityGate(branch, this.issueIndex), null, analysisProperties);
        return this.webhookPayloadFactory.create(projectAnalysis);
    }

    private QualityGate createQualityGate(ComponentDto branch, IssueIndex issueIndex) {
        SearchResponse searchResponse = issueIndex.search(IssueQuery.builder().projectUuids(Collections.singletonList(branch.getMainBranchProjectUuid())).branchUuid(branch.uuid()).mainBranch(false).resolved(false).checkAuthorization(false).build(), new SearchOptions().addFacets("types"));
        LinkedHashMap<String, Long> typeFacet = new Facets(searchResponse, this.system2.getDefaultTimeZone()).get("types");
        Set conditions = (Set)ShortLivingBranchQualityGate.CONDITIONS.stream().map(c -> IssueChangeWebhookImpl.toCondition(typeFacet, c)).collect(MoreCollectors.toSet((int)ShortLivingBranchQualityGate.CONDITIONS.size()));
        return new QualityGate(String.valueOf(-1963456987L), "Hardcoded short living branch quality gate", IssueChangeWebhookImpl.qgStatusFrom(conditions), conditions);
    }

    private static QualityGate.Condition toCondition(LinkedHashMap<String, Long> typeFacet, ShortLivingBranchQualityGate.Condition c) {
        long measure = IssueChangeWebhookImpl.getMeasure(typeFacet, c);
        QualityGate.EvaluationStatus status = measure > 0L ? QualityGate.EvaluationStatus.ERROR : QualityGate.EvaluationStatus.OK;
        return new QualityGate.Condition(status, c.getMetricKey(), IssueChangeWebhookImpl.toOperator(c), c.getErrorThreshold(), c.getWarnThreshold(), c.isOnLeak(), String.valueOf(measure));
    }

    private static QualityGate.Operator toOperator(ShortLivingBranchQualityGate.Condition c) {
        String operator;
        switch (operator = c.getOperator()) {
            case "GT": {
                return QualityGate.Operator.GREATER_THAN;
            }
            case "LT": {
                return QualityGate.Operator.LESS_THAN;
            }
            case "EQ": {
                return QualityGate.Operator.EQUALS;
            }
            case "NE": {
                return QualityGate.Operator.NOT_EQUALS;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported Condition operator '%s'", operator));
    }

    private static QualityGate.Status qgStatusFrom(Set<QualityGate.Condition> conditions) {
        if (conditions.stream().anyMatch(c -> c.getStatus() == QualityGate.EvaluationStatus.ERROR)) {
            return QualityGate.Status.ERROR;
        }
        return QualityGate.Status.OK;
    }

    private static long getMeasure(LinkedHashMap<String, Long> typeFacet, ShortLivingBranchQualityGate.Condition c) {
        String metricKey;
        switch (metricKey = c.getMetricKey()) {
            case "bugs": {
                return IssueChangeWebhookImpl.getValueForRuleType(typeFacet, RuleType.BUG);
            }
            case "vulnerabilities": {
                return IssueChangeWebhookImpl.getValueForRuleType(typeFacet, RuleType.VULNERABILITY);
            }
            case "code_smells": {
                return IssueChangeWebhookImpl.getValueForRuleType(typeFacet, RuleType.CODE_SMELL);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported metric key '%s' in hardcoded quality gate", metricKey));
    }

    private static long getValueForRuleType(Map<String, Long> facet, RuleType ruleType) {
        Long res = facet.get(ruleType.name());
        if (res == null) {
            return 0L;
        }
        return res;
    }

    private Map<String, ComponentDto> getBranchComponents(DbSession dbSession, IssueChangeWebhook.IssueChangeData issueChangeData) {
        Set projectUuids = (Set)issueChangeData.getIssues().stream().map(DefaultIssue::projectUuid).collect(MoreCollectors.toSet());
        ImmutableSet missingProjectUuids = ImmutableSet.copyOf((Collection)Sets.difference((Set)projectUuids, issueChangeData.getComponents().stream().map(ComponentDto::uuid).collect(Collectors.toSet())));
        if (missingProjectUuids.isEmpty()) {
            return (Map)issueChangeData.getComponents().stream().filter(c -> projectUuids.contains(c.uuid())).filter(componentDto -> componentDto.getMainBranchProjectUuid() != null).collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
        }
        return (Map)Stream.concat(issueChangeData.getComponents().stream().filter(c -> projectUuids.contains(c.uuid())), this.dbClient.componentDao().selectByUuids(dbSession, (Collection)missingProjectUuids).stream()).filter(componentDto -> componentDto.getMainBranchProjectUuid() != null).collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
    }
}

