/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.config.Configuration;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;

public class IssueIndexDefinition
implements IndexDefinition {
    public static final IndexType INDEX_TYPE_ISSUE = new IndexType("issues", "issue");
    public static final String FIELD_ISSUE_ASSIGNEE = "assignee";
    public static final String FIELD_ISSUE_AUTHOR_LOGIN = "authorLogin";
    public static final String FIELD_ISSUE_COMPONENT_UUID = "component";
    public static final String FIELD_ISSUE_EFFORT = "effort";
    public static final String FIELD_ISSUE_FILE_PATH = "filePath";
    public static final String FIELD_ISSUE_FUNC_CREATED_AT = "issueCreatedAt";
    public static final String FIELD_ISSUE_FUNC_UPDATED_AT = "issueUpdatedAt";
    public static final String FIELD_ISSUE_FUNC_CLOSED_AT = "issueClosedAt";
    public static final String FIELD_ISSUE_KEY = "key";
    public static final String FIELD_ISSUE_LANGUAGE = "language";
    public static final String FIELD_ISSUE_LINE = "line";
    public static final String FIELD_ISSUE_MODULE_UUID = "module";
    public static final String FIELD_ISSUE_MODULE_PATH = "modulePath";
    public static final String FIELD_ISSUE_ORGANIZATION_UUID = "organization";
    public static final String FIELD_ISSUE_PROJECT_UUID = "project";
    public static final String FIELD_ISSUE_BRANCH_UUID = "branch";
    public static final String FIELD_ISSUE_IS_MAIN_BRANCH = "isMainBranch";
    public static final String FIELD_ISSUE_DIRECTORY_PATH = "dirPath";
    public static final String FIELD_ISSUE_RESOLUTION = "resolution";
    public static final String FIELD_ISSUE_RULE_KEY = "ruleKey";
    public static final String FIELD_ISSUE_SEVERITY = "severity";
    public static final String FIELD_ISSUE_SEVERITY_VALUE = "severityValue";
    public static final String FIELD_ISSUE_STATUS = "status";
    public static final String FIELD_ISSUE_TAGS = "tags";
    public static final String FIELD_ISSUE_TYPE = "type";
    private final Configuration config;
    private final boolean enableSource;

    public IssueIndexDefinition(Configuration config) {
        this(config, false);
    }

    private IssueIndexDefinition(Configuration config, boolean enableSource) {
        this.config = config;
        this.enableSource = enableSource;
    }

    @VisibleForTesting
    public static IssueIndexDefinition createForTest(Configuration config) {
        return new IssueIndexDefinition(config, true);
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewIndex index = context.create(INDEX_TYPE_ISSUE.getIndex(), NewIndex.SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build());
        NewIndex.NewIndexType type = index.createType(INDEX_TYPE_ISSUE.getType());
        type.requireProjectAuthorization();
        type.setEnableSource(this.enableSource);
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_ASSIGNEE).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_AUTHOR_LOGIN).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_COMPONENT_UUID).disableNorms()).build();
        type.createLongField(FIELD_ISSUE_EFFORT);
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_FILE_PATH).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        type.createDateTimeField(FIELD_ISSUE_FUNC_CREATED_AT);
        type.createDateTimeField(FIELD_ISSUE_FUNC_UPDATED_AT);
        type.createDateTimeField(FIELD_ISSUE_FUNC_CLOSED_AT);
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_KEY).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_LANGUAGE).disableNorms()).build();
        type.createIntegerField(FIELD_ISSUE_LINE);
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_MODULE_UUID).disableNorms()).build();
        type.createUuidPathField(FIELD_ISSUE_MODULE_PATH);
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_ORGANIZATION_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_PROJECT_UUID).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_BRANCH_UUID).disableNorms()).build();
        type.createBooleanField(FIELD_ISSUE_IS_MAIN_BRANCH);
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_DIRECTORY_PATH).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_RESOLUTION).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_RULE_KEY).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_SEVERITY).disableNorms()).build();
        type.createByteField(FIELD_ISSUE_SEVERITY_VALUE);
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_STATUS).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_TAGS).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)type.keywordFieldBuilder(FIELD_ISSUE_TYPE).disableNorms()).build();
    }
}

