/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.issue.Issue;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.workflow.IssueWorkflow;
import org.sonar.server.issue.workflow.Transition;
import org.sonar.server.user.UserSession;

public class TransitionService {
    private final UserSession userSession;
    private final IssueWorkflow workflow;

    public TransitionService(UserSession userSession, IssueWorkflow workflow) {
        this.userSession = userSession;
        this.workflow = workflow;
    }

    public List<Transition> listTransitions(DefaultIssue issue) {
        String projectUuid = Objects.requireNonNull(issue.projectUuid());
        return (List)this.workflow.outTransitions((Issue)issue).stream().filter(transition -> this.userSession.isLoggedIn() && StringUtils.isBlank((String)transition.requiredProjectPermission()) || this.userSession.hasComponentUuidPermission(transition.requiredProjectPermission(), projectUuid)).collect(MoreCollectors.toList());
    }

    public boolean doTransition(DefaultIssue defaultIssue, IssueChangeContext issueChangeContext, String transitionKey) {
        return this.workflow.doTransition(defaultIssue, transitionKey, issueChangeContext);
    }

    public void checkTransitionPermission(String transitionKey, DefaultIssue defaultIssue) {
        String projectUuid = Objects.requireNonNull(defaultIssue.projectUuid());
        this.workflow.outTransitions((Issue)defaultIssue).stream().filter(transition -> transition.key().equals(transitionKey) && StringUtils.isNotBlank((String)transition.requiredProjectPermission())).forEach(transition -> this.userSession.checkComponentUuidPermission(transition.requiredProjectPermission(), projectUuid));
    }
}

