/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.issue.condition.Condition;
import org.sonar.api.issue.condition.IsUnResolved;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.user.UserSession;

@ServerSide
public class SetSeverityAction
extends Action {
    public static final String SET_SEVERITY_KEY = "set_severity";
    public static final String SEVERITY_PARAMETER = "severity";
    private final IssueFieldsSetter issueUpdater;
    private final UserSession userSession;

    public SetSeverityAction(IssueFieldsSetter issueUpdater, UserSession userSession) {
        super(SET_SEVERITY_KEY);
        this.issueUpdater = issueUpdater;
        this.userSession = userSession;
        super.setConditions(new Condition[]{new IsUnResolved(), issue -> this.isCurrentUserIssueAdmin(issue.projectUuid())});
    }

    private boolean isCurrentUserIssueAdmin(String projectUuid) {
        return this.userSession.hasComponentUuidPermission("issueadmin", projectUuid);
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        SetSeverityAction.verifySeverityParameter(properties);
        return true;
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        return this.issueUpdater.setManualSeverity(context.issue(), SetSeverityAction.verifySeverityParameter(properties), context.issueChangeContext());
    }

    private static String verifySeverityParameter(Map<String, Object> properties) {
        String param = (String)properties.get(SEVERITY_PARAMETER);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)param) ? 1 : 0) != 0, (String)"Missing parameter : '%s'", (Object[])new Object[]{SEVERITY_PARAMETER});
        return param;
    }
}

