/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.picocontainer.Startable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.InternalPropertiesDao;
import org.sonar.server.edition.EditionManagementState;
import org.sonar.server.edition.License;
import org.sonar.server.edition.MutableEditionManagementState;

public class StandaloneEditionManagementStateImpl
implements MutableEditionManagementState,
Startable {
    private static final String CURRENT_EDITION_KEY = "currentEditionKey";
    private static final String PENDING_INSTALLATION_STATUS = "pendingInstallStatus";
    private static final String PENDING_EDITION_KEY = "pendingEditionKey";
    private static final String PENDING_LICENSE = "pendingLicense";
    private static final String INSTALL_ERROR_MESSAGE = "installError";
    private final DbClient dbClient;
    @CheckForNull
    private State state;

    public StandaloneEditionManagementStateImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map internalPropertyValues = this.dbClient.internalPropertiesDao().selectByKeys(dbSession, (Set)ImmutableSet.of((Object)CURRENT_EDITION_KEY, (Object)PENDING_INSTALLATION_STATUS, (Object)PENDING_EDITION_KEY, (Object)PENDING_LICENSE, (Object)INSTALL_ERROR_MESSAGE));
            EditionManagementState.PendingStatus pendingInstallationStatus = internalPropertyValues.getOrDefault(PENDING_INSTALLATION_STATUS, Optional.empty()).map(StandaloneEditionManagementStateImpl::emptyToNull).map(EditionManagementState.PendingStatus::valueOf).orElse(EditionManagementState.PendingStatus.NONE);
            State.Builder builder = State.newBuilder(pendingInstallationStatus);
            builder.setCurrentEditionKey(internalPropertyValues.getOrDefault(CURRENT_EDITION_KEY, Optional.empty()).map(StandaloneEditionManagementStateImpl::emptyToNull).orElse(null)).setPendingEditionKey(internalPropertyValues.getOrDefault(PENDING_EDITION_KEY, Optional.empty()).map(StandaloneEditionManagementStateImpl::emptyToNull).orElse(null)).setPendingLicense(internalPropertyValues.getOrDefault(PENDING_LICENSE, Optional.empty()).map(StandaloneEditionManagementStateImpl::emptyToNull).orElse(null)).setInstallErrorMessage(internalPropertyValues.getOrDefault(INSTALL_ERROR_MESSAGE, Optional.empty()).map(StandaloneEditionManagementStateImpl::emptyToNull).orElse(null));
            this.state = builder.build();
        }
    }

    public void stop() {
    }

    @Override
    public Optional<String> getCurrentEditionKey() {
        this.ensureStarted();
        return Optional.ofNullable(this.state.getCurrentEditionKey());
    }

    @Override
    public EditionManagementState.PendingStatus getPendingInstallationStatus() {
        this.ensureStarted();
        return this.state.getPendingInstallationStatus();
    }

    @Override
    public Optional<String> getPendingEditionKey() {
        this.ensureStarted();
        return Optional.ofNullable(this.state.getPendingEditionKey());
    }

    @Override
    public Optional<String> getPendingLicense() {
        this.ensureStarted();
        return Optional.ofNullable(this.state.getPendingLicense());
    }

    @Override
    public Optional<String> getInstallErrorMessage() {
        this.ensureStarted();
        return Optional.ofNullable(this.state.getInstallErrorMessage());
    }

    @Override
    public synchronized EditionManagementState.PendingStatus startAutomaticInstall(License license) {
        this.ensureStarted();
        StandaloneEditionManagementStateImpl.checkLicense(license);
        State newState = this.changeStatusToFrom(EditionManagementState.PendingStatus.AUTOMATIC_IN_PROGRESS, EditionManagementState.PendingStatus.NONE).setPendingLicense(license.getContent()).setPendingEditionKey(license.getEditionKey()).clearAutomaticInstallErrorMessage().build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    @Override
    public synchronized EditionManagementState.PendingStatus startManualInstall(License license) {
        this.ensureStarted();
        StandaloneEditionManagementStateImpl.checkLicense(license);
        State newState = this.changeStatusToFrom(EditionManagementState.PendingStatus.MANUAL_IN_PROGRESS, EditionManagementState.PendingStatus.NONE).setPendingLicense(license.getContent()).setPendingEditionKey(license.getEditionKey()).clearAutomaticInstallErrorMessage().build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    @Override
    public synchronized EditionManagementState.PendingStatus newEditionWithoutInstall(String newEditionKey) {
        this.ensureStarted();
        Objects.requireNonNull(newEditionKey, "newEditionKey can't be null");
        Preconditions.checkArgument((!newEditionKey.isEmpty() ? 1 : 0) != 0, (Object)"newEditionKey can't be empty");
        State newState = this.changeStatusToFrom(EditionManagementState.PendingStatus.NONE, EditionManagementState.PendingStatus.NONE).setCurrentEditionKey(newEditionKey).clearAutomaticInstallErrorMessage().build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    @Override
    public synchronized EditionManagementState.PendingStatus automaticInstallReady() {
        this.ensureStarted();
        State newState = this.changeStatusToFrom(EditionManagementState.PendingStatus.AUTOMATIC_READY, EditionManagementState.PendingStatus.AUTOMATIC_IN_PROGRESS).clearAutomaticInstallErrorMessage().build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    @Override
    public synchronized EditionManagementState.PendingStatus installFailed(@Nullable String errorMessage) {
        this.ensureStarted();
        State newState = this.changeStatusToFrom(EditionManagementState.PendingStatus.NONE, EditionManagementState.PendingStatus.AUTOMATIC_IN_PROGRESS, EditionManagementState.PendingStatus.MANUAL_IN_PROGRESS).setInstallErrorMessage(StandaloneEditionManagementStateImpl.nullableTrimmedEmptyToNull(errorMessage)).clearPendingFields().build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    @Override
    public synchronized void clearInstallErrorMessage() {
        this.ensureStarted();
        State currentState = this.state;
        if (currentState.getInstallErrorMessage() != null) {
            State newState = State.newBuilder(currentState).clearAutomaticInstallErrorMessage().build();
            this.persistProperties(newState);
        }
    }

    @Override
    public synchronized EditionManagementState.PendingStatus finalizeInstallation(@Nullable String errorMessage) {
        this.ensureStarted();
        State newState = this.changeStatusToFrom(EditionManagementState.PendingStatus.NONE, EditionManagementState.PendingStatus.AUTOMATIC_READY, EditionManagementState.PendingStatus.MANUAL_IN_PROGRESS, EditionManagementState.PendingStatus.UNINSTALL_IN_PROGRESS).commitPendingEditionKey().clearPendingFields().setInstallErrorMessage(StandaloneEditionManagementStateImpl.nullableTrimmedEmptyToNull(errorMessage)).build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    @Override
    public synchronized EditionManagementState.PendingStatus uninstall() {
        this.ensureStarted();
        State.Builder builder = this.changeStatusToFrom(EditionManagementState.PendingStatus.UNINSTALL_IN_PROGRESS, EditionManagementState.PendingStatus.NONE);
        Preconditions.checkState((this.state.currentEditionKey != null ? 1 : 0) != 0, (Object)"There is no edition currently installed");
        State newState = builder.clearPendingFields().clearCurrentEditionKey().clearAutomaticInstallErrorMessage().build();
        this.persistProperties(newState);
        return newState.getPendingInstallationStatus();
    }

    private void ensureStarted() {
        Preconditions.checkState((this.state != null ? 1 : 0) != 0, (String)"%s is not started", (Object[])new Object[]{this.getClass().getSimpleName()});
    }

    private State.Builder changeStatusToFrom(EditionManagementState.PendingStatus newStatus, EditionManagementState.PendingStatus ... validPendingStatuses) {
        State currentState = this.state;
        if (Arrays.stream(validPendingStatuses).noneMatch(s -> s == currentState.getPendingInstallationStatus())) {
            throw new IllegalStateException(String.format("Can't move to %s when status is %s (should be any of %s)", new Object[]{newStatus, currentState.getPendingInstallationStatus(), Arrays.toString((Object[])validPendingStatuses)}));
        }
        return State.newBuilder(currentState, newStatus);
    }

    private void persistProperties(State newState) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            InternalPropertiesDao internalPropertiesDao = this.dbClient.internalPropertiesDao();
            StandaloneEditionManagementStateImpl.saveInternalProperty(internalPropertiesDao, dbSession, PENDING_EDITION_KEY, newState.getPendingEditionKey());
            StandaloneEditionManagementStateImpl.saveInternalProperty(internalPropertiesDao, dbSession, PENDING_LICENSE, newState.getPendingLicense());
            StandaloneEditionManagementStateImpl.saveInternalProperty(internalPropertiesDao, dbSession, INSTALL_ERROR_MESSAGE, newState.getInstallErrorMessage());
            StandaloneEditionManagementStateImpl.saveInternalProperty(internalPropertiesDao, dbSession, CURRENT_EDITION_KEY, newState.getCurrentEditionKey());
            StandaloneEditionManagementStateImpl.saveInternalProperty(internalPropertiesDao, dbSession, PENDING_INSTALLATION_STATUS, newState.getPendingInstallationStatus().name());
            dbSession.commit();
            this.state = newState;
        }
    }

    private static void saveInternalProperty(InternalPropertiesDao dao, DbSession dbSession, String key, @Nullable String value) {
        if (value == null) {
            dao.saveAsEmpty(dbSession, key);
        } else {
            dao.save(dbSession, key, value);
        }
    }

    private static void checkLicense(License license) {
        Objects.requireNonNull(license, "license can't be null");
    }

    private static String nullableTrimmedEmptyToNull(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String v = s.trim();
        return v.isEmpty() ? null : v;
    }

    private static String emptyToNull(String s) {
        return s.isEmpty() ? null : s;
    }

    @Immutable
    private static final class State {
        private final String currentEditionKey;
        private final EditionManagementState.PendingStatus pendingInstallationStatus;
        private final String pendingEditionKey;
        private final String pendingLicense;
        private final String installErrorMessage;

        public State(Builder builder) {
            this.currentEditionKey = builder.currentEditionKey;
            this.pendingInstallationStatus = builder.pendingInstallationStatus;
            this.pendingEditionKey = builder.pendingEditionKey;
            this.pendingLicense = builder.pendingLicense;
            this.installErrorMessage = builder.installErrorMessage;
        }

        public String getCurrentEditionKey() {
            return this.currentEditionKey;
        }

        public EditionManagementState.PendingStatus getPendingInstallationStatus() {
            return this.pendingInstallationStatus;
        }

        public String getPendingEditionKey() {
            return this.pendingEditionKey;
        }

        public String getPendingLicense() {
            return this.pendingLicense;
        }

        public String getInstallErrorMessage() {
            return this.installErrorMessage;
        }

        public static Builder newBuilder(EditionManagementState.PendingStatus pendingInstallationStatus) {
            return new Builder(pendingInstallationStatus);
        }

        public static Builder newBuilder(State from) {
            return State.newBuilder(from, from.getPendingInstallationStatus());
        }

        public static Builder newBuilder(State from, EditionManagementState.PendingStatus newStatus) {
            return new Builder(newStatus).setCurrentEditionKey(from.currentEditionKey).setPendingEditionKey(from.pendingEditionKey).setPendingLicense(from.pendingLicense).setInstallErrorMessage(from.installErrorMessage);
        }

        private static class Builder {
            private EditionManagementState.PendingStatus pendingInstallationStatus;
            private String currentEditionKey;
            private String pendingEditionKey;
            private String pendingLicense;
            private String installErrorMessage;

            private Builder(EditionManagementState.PendingStatus pendingInstallationStatus) {
                this.pendingInstallationStatus = Objects.requireNonNull(pendingInstallationStatus);
            }

            public Builder setCurrentEditionKey(@Nullable String currentEditionKey) {
                this.currentEditionKey = currentEditionKey;
                return this;
            }

            public Builder setPendingEditionKey(@Nullable String pendingEditionKey) {
                this.pendingEditionKey = pendingEditionKey;
                return this;
            }

            public Builder setPendingLicense(@Nullable String pendingLicense) {
                this.pendingLicense = pendingLicense;
                return this;
            }

            public Builder setInstallErrorMessage(@Nullable String installErrorMessage) {
                this.installErrorMessage = installErrorMessage;
                return this;
            }

            public Builder commitPendingEditionKey() {
                this.currentEditionKey = this.pendingEditionKey;
                return this;
            }

            public Builder clearCurrentEditionKey() {
                this.currentEditionKey = null;
                return this;
            }

            public Builder clearPendingFields() {
                this.pendingEditionKey = null;
                this.pendingLicense = null;
                return this;
            }

            public Builder clearAutomaticInstallErrorMessage() {
                this.installErrorMessage = null;
                return this;
            }

            public State build() {
                return new State(this);
            }
        }
    }
}

