/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.webhook;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.ce.posttask.Analysis;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.config.Configuration;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.CeTask;
import org.sonar.server.webhook.Project;
import org.sonar.server.webhook.ProjectAnalysis;
import org.sonar.server.webhook.QualityGate;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.WebhookPayloadFactory;

public class WebhookPostTask
implements PostProjectAnalysisTask {
    private final ConfigurationRepository configRepository;
    private final WebhookPayloadFactory payloadFactory;
    private final WebHooks webHooks;

    public WebhookPostTask(ConfigurationRepository configRepository, WebhookPayloadFactory payloadFactory, WebHooks webHooks) {
        this.configRepository = configRepository;
        this.payloadFactory = payloadFactory;
        this.webHooks = webHooks;
    }

    public void finished(PostProjectAnalysisTask.ProjectAnalysis analysis) {
        Configuration config = this.configRepository.getConfiguration();
        this.webHooks.sendProjectAnalysisUpdate(config, new WebHooks.Analysis(analysis.getProject().getUuid(), analysis.getAnalysis().map(Analysis::getAnalysisUuid).orElse(null), analysis.getCeTask().getId()), () -> this.payloadFactory.create(WebhookPostTask.convert(analysis)));
    }

    private static ProjectAnalysis convert(PostProjectAnalysisTask.ProjectAnalysis projectAnalysis) {
        CeTask ceTask = new CeTask(projectAnalysis.getCeTask().getId(), CeTask.Status.valueOf(projectAnalysis.getCeTask().getStatus().name()));
        Project project = new Project(projectAnalysis.getProject().getUuid(), projectAnalysis.getProject().getKey(), projectAnalysis.getProject().getName());
        org.sonar.server.webhook.Analysis analysis = projectAnalysis.getAnalysis().map(a -> new org.sonar.server.webhook.Analysis(a.getAnalysisUuid(), a.getDate().getTime())).orElse(null);
        Branch branch = projectAnalysis.getBranch().map(b -> new Branch(b.isMain(), b.getName().orElse(null), Branch.Type.valueOf(b.getType().name()))).orElse(null);
        QualityGate qualityGate = Optional.ofNullable(projectAnalysis.getQualityGate()).map(qg -> new QualityGate(qg.getId(), qg.getName(), QualityGate.Status.valueOf(qg.getStatus().name()), qg.getConditions().stream().map(c -> new QualityGate.Condition(QualityGate.EvaluationStatus.valueOf(c.getStatus().name()), c.getMetricKey(), QualityGate.Operator.valueOf(c.getOperator().name()), c.getErrorThreshold(), c.getWarningThreshold(), c.isOnLeakPeriod(), c.getStatus() == QualityGate.EvaluationStatus.NO_VALUE ? null : c.getValue())).collect(Collectors.toSet()))).orElse(null);
        Long date = projectAnalysis.getAnalysis().map(a -> a.getDate().getTime()).orElse(null);
        Map properties = projectAnalysis.getScannerContext().getProperties();
        return new ProjectAnalysis(project, ceTask, analysis, branch, qualityGate, date, properties);
    }
}

