/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.core.component.ComponentKeys;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.step.ComputationStep;

public class ValidateProjectStep
implements ComputationStep {
    private static final Joiner MESSAGES_JOINER = Joiner.on((String)"\n  o ");
    private final DbClient dbClient;
    private final BatchReportReader reportReader;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public ValidateProjectStep(DbClient dbClient, BatchReportReader reportReader, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.reportReader = reportReader;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Component root = this.treeRootHolder.getRoot();
            List baseModules = this.dbClient.componentDao().selectEnabledModulesFromProjectKey(dbSession, root.getKey());
            ImmutableMap baseModulesByKey = FluentIterable.from((Iterable)baseModules).uniqueIndex(ComponentDto::getDbKey);
            ValidateProjectsVisitor visitor = new ValidateProjectsVisitor(dbSession, this.dbClient.componentDao(), (Map<String, ComponentDto>)baseModulesByKey);
            new DepthTraversalTypeAwareCrawler(visitor).visit(root);
            if (!visitor.validationMessages.isEmpty()) {
                throw MessageException.of((String)("Validation of project failed:\n  o " + MESSAGES_JOINER.join((Iterable)visitor.validationMessages)));
            }
        }
    }

    @Override
    public String getDescription() {
        return "Validate project";
    }

    private class ValidateProjectsVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private final ComponentDao componentDao;
        private final Map<String, ComponentDto> baseModulesByKey;
        private final List<String> validationMessages;
        private Component rawProject;

        public ValidateProjectsVisitor(DbSession session, ComponentDao componentDao, Map<String, ComponentDto> baseModulesByKey) {
            super(CrawlerDepthLimit.MODULE, ComponentVisitor.Order.PRE_ORDER);
            this.validationMessages = new ArrayList<String>();
            this.session = session;
            this.componentDao = componentDao;
            this.baseModulesByKey = baseModulesByKey;
        }

        @Override
        public void visitProject(Component rawProject) {
            this.rawProject = rawProject;
            String rawProjectKey = rawProject.getKey();
            com.google.common.base.Optional<ComponentDto> baseProject = this.loadBaseComponent(rawProjectKey);
            this.validateAnalysisDate(baseProject);
        }

        private void validateAnalysisDate(com.google.common.base.Optional<ComponentDto> baseProject) {
            if (baseProject.isPresent()) {
                Optional snapshotDto = ValidateProjectStep.this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(this.session, ((ComponentDto)baseProject.get()).uuid());
                long currentAnalysisDate = ValidateProjectStep.this.analysisMetadataHolder.getAnalysisDate();
                Long lastAnalysisDate = snapshotDto.map(SnapshotDto::getCreatedAt).orElse(null);
                if (lastAnalysisDate != null && currentAnalysisDate <= lastAnalysisDate) {
                    this.validationMessages.add(String.format("Date of analysis cannot be older than the date of the last known analysis on this project. Value: \"%s\". Latest analysis: \"%s\". It's only possible to rebuild the past in a chronological order.", DateUtils.formatDateTime((Date)new Date(currentAnalysisDate)), DateUtils.formatDateTime((Date)new Date(lastAnalysisDate))));
                }
            }
        }

        @Override
        public void visitModule(Component rawModule) {
            String rawProjectKey = this.rawProject.getKey();
            String rawModuleKey = rawModule.getKey();
            this.validateBatchKey(rawModule);
            com.google.common.base.Optional<ComponentDto> baseModule = this.loadBaseComponent(rawModuleKey);
            if (!baseModule.isPresent()) {
                return;
            }
            this.validateModuleIsNotAlreadyUsedAsProject((ComponentDto)baseModule.get(), rawProjectKey, rawModuleKey);
            this.validateModuleKeyIsNotAlreadyUsedInAnotherProject((ComponentDto)baseModule.get(), rawModuleKey);
        }

        private void validateModuleIsNotAlreadyUsedAsProject(ComponentDto baseModule, String rawProjectKey, String rawModuleKey) {
            if (baseModule.projectUuid().equals(baseModule.uuid())) {
                this.validationMessages.add(String.format("The project \"%s\" is already defined in SonarQube but not as a module of project \"%s\". If you really want to stop directly analysing project \"%s\", please first delete it from SonarQube and then relaunch the analysis of project \"%s\".", rawModuleKey, rawProjectKey, rawModuleKey, rawProjectKey));
            }
        }

        private void validateModuleKeyIsNotAlreadyUsedInAnotherProject(ComponentDto baseModule, String rawModuleKey) {
            if (!baseModule.projectUuid().equals(baseModule.uuid()) && !baseModule.projectUuid().equals(this.rawProject.getUuid())) {
                ComponentDto projectModule = this.componentDao.selectOrFailByUuid(this.session, baseModule.projectUuid());
                this.validationMessages.add(String.format("Module \"%s\" is already part of project \"%s\"", rawModuleKey, projectModule.getDbKey()));
            }
        }

        private void validateBatchKey(Component rawComponent) {
            String batchKey = ValidateProjectStep.this.reportReader.readComponent(rawComponent.getReportAttributes().getRef()).getKey();
            if (!ComponentKeys.isValidModuleKey((String)batchKey)) {
                this.validationMessages.add(String.format("\"%s\" is not a valid project or module key. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", batchKey));
            }
        }

        private com.google.common.base.Optional<ComponentDto> loadBaseComponent(String rawComponentKey) {
            ComponentDto baseComponent = this.baseModulesByKey.get(rawComponentKey);
            if (baseComponent == null) {
                return this.componentDao.selectByKey(this.session, rawComponentKey);
            }
            return com.google.common.base.Optional.of((Object)baseComponent);
        }
    }
}

