/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.formula.VariationSumFormula;
import org.sonar.server.computation.task.projectanalysis.formula.counter.IntValue;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredMetricKeys;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredVariationFormula;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.SingleWithUncoveredMetricKeys;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.SingleWithUncoveredVariationFormula;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class NewCoverageMeasuresStep
implements ComputationStep {
    private static final List<Formula> FORMULAS = ImmutableList.of((Object)new NewCoverageFormula(), (Object)new NewBranchCoverageFormula(), (Object)new NewLineCoverageFormula());
    private final TreeRootHolder treeRootHolder;
    private final PeriodHolder periodHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    @CheckForNull
    private final ScmInfoRepository scmInfoRepository;

    public NewCoverageMeasuresStep(TreeRootHolder treeRootHolder, PeriodHolder periodHolder, MeasureRepository measureRepository, MetricRepository metricRepository, ScmInfoRepository scmInfoRepository) {
        this.treeRootHolder = treeRootHolder;
        this.periodHolder = periodHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.scmInfoRepository = scmInfoRepository;
    }

    public NewCoverageMeasuresStep(TreeRootHolder treeRootHolder, PeriodHolder periodHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        this.treeRootHolder = treeRootHolder;
        this.periodHolder = periodHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.scmInfoRepository = null;
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).withVariationSupport(this.periodHolder).buildFor(Iterables.concat(NewLinesAndConditionsCoverageFormula.from(this.scmInfoRepository), FORMULAS))).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute new coverage";
    }

    @Immutable
    public static class NewCoverageInputMetricKeys {
        private final String coverageLineHitsData;
        private final String conditionsByLine;
        private final String coveredConditionsByLine;

        public NewCoverageInputMetricKeys(String coverageLineHitsData, String conditionsByLine, String coveredConditionsByLine) {
            this.coverageLineHitsData = coverageLineHitsData;
            this.conditionsByLine = conditionsByLine;
            this.coveredConditionsByLine = coveredConditionsByLine;
        }

        public String getCoverageLineHitsData() {
            return this.coverageLineHitsData;
        }

        public String getConditionsByLine() {
            return this.conditionsByLine;
        }

        public String getCoveredConditionsByLine() {
            return this.coveredConditionsByLine;
        }
    }

    @Immutable
    public static final class NewCoverageOutputMetricKeys {
        private final String newLinesToCover;
        private final String newUncoveredLines;
        private final String newConditionsToCover;
        private final String newUncoveredConditions;

        public NewCoverageOutputMetricKeys(String newLinesToCover, String newUncoveredLines, String newConditionsToCover, String newUncoveredConditions) {
            this.newLinesToCover = newLinesToCover;
            this.newUncoveredLines = newUncoveredLines;
            this.newConditionsToCover = newConditionsToCover;
            this.newUncoveredConditions = newUncoveredConditions;
        }

        public String getNewLinesToCover() {
            return this.newLinesToCover;
        }

        public String getNewUncoveredLines() {
            return this.newUncoveredLines;
        }

        public String getNewConditionsToCover() {
            return this.newConditionsToCover;
        }

        public String getNewUncoveredConditions() {
            return this.newUncoveredConditions;
        }
    }

    public static final class NewCoverageCounter
    implements Counter<NewCoverageCounter> {
        private final IntValue newLines = new IntValue();
        private final IntValue newCoveredLines = new IntValue();
        private final IntValue newConditions = new IntValue();
        private final IntValue newCoveredConditions = new IntValue();
        private final ScmInfoRepository scmInfoRepository;
        private final NewCoverageInputMetricKeys metricKeys;

        public NewCoverageCounter(ScmInfoRepository scmInfoRepository, NewCoverageInputMetricKeys metricKeys) {
            this.scmInfoRepository = scmInfoRepository;
            this.metricKeys = metricKeys;
        }

        @Override
        public void aggregate(NewCoverageCounter counter) {
            this.newLines.increment(counter.newLines);
            this.newCoveredLines.increment(counter.newCoveredLines);
            this.newConditions.increment(counter.newConditions);
            this.newCoveredConditions.increment(counter.newCoveredConditions);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Component fileComponent = context.getLeaf();
            Optional<ScmInfo> scmInfoOptional = this.scmInfoRepository.getScmInfo(fileComponent);
            if (!scmInfoOptional.isPresent() || !context.hasPeriod()) {
                return;
            }
            ScmInfo componentScm = (ScmInfo)scmInfoOptional.get();
            this.newLines.increment(0);
            this.newCoveredLines.increment(0);
            this.newConditions.increment(0);
            this.newCoveredConditions.increment(0);
            Optional<Measure> hitsByLineMeasure = context.getMeasure(this.metricKeys.getCoverageLineHitsData());
            Map<Integer, Integer> hitsByLine = NewCoverageCounter.parseCountByLine(hitsByLineMeasure);
            Map<Integer, Integer> conditionsByLine = NewCoverageCounter.parseCountByLine(context.getMeasure(this.metricKeys.getConditionsByLine()));
            Map<Integer, Integer> coveredConditionsByLine = NewCoverageCounter.parseCountByLine(context.getMeasure(this.metricKeys.getCoveredConditionsByLine()));
            for (Map.Entry<Integer, Integer> entry : hitsByLine.entrySet()) {
                int lineId = entry.getKey();
                int hits = entry.getValue();
                int conditions = (Integer)ObjectUtils.defaultIfNull((Object)conditionsByLine.get(lineId), (Object)0);
                int coveredConditions = (Integer)ObjectUtils.defaultIfNull((Object)coveredConditionsByLine.get(lineId), (Object)0);
                long date = componentScm.getChangesetForLine(lineId).getDate();
                this.analyze(context.getPeriod(), date, hits, conditions, coveredConditions);
            }
        }

        private static Map<Integer, Integer> parseCountByLine(Optional<Measure> measure) {
            if (measure.isPresent() && ((Measure)measure.get()).getValueType() != Measure.ValueType.NO_VALUE) {
                return KeyValueFormat.parseIntInt((String)((Measure)measure.get()).getStringValue());
            }
            return Collections.emptyMap();
        }

        void analyze(Period period, @Nullable Long lineDate, int hits, int conditions, int coveredConditions) {
            if (lineDate == null) {
                return;
            }
            if (NewCoverageCounter.isLineInPeriod(lineDate, period)) {
                this.incrementLines(hits);
                this.incrementConditions(conditions, coveredConditions);
            }
        }

        private static boolean isLineInPeriod(long lineDate, Period period) {
            return lineDate > period.getSnapshotDate();
        }

        private void incrementLines(int hits) {
            this.newLines.increment(1);
            if (hits > 0) {
                this.newCoveredLines.increment(1);
            }
        }

        private void incrementConditions(int conditions, int coveredConditions) {
            this.newConditions.increment(conditions);
            if (conditions > 0) {
                this.newCoveredConditions.increment(coveredConditions);
            }
        }

        boolean hasNewCode() {
            return this.newLines.isSet();
        }

        int getNewLines() {
            return this.newLines.getValue();
        }

        int getNewCoveredLines() {
            return this.newCoveredLines.getValue();
        }

        int getNewConditions() {
            return this.newConditions.getValue();
        }

        int getNewCoveredConditions() {
            return this.newCoveredConditions.getValue();
        }
    }

    public static class NewLinesAndConditionsFormula
    implements Formula<NewCoverageCounter> {
        private final ScmInfoRepository scmInfoRepository;
        private final NewCoverageInputMetricKeys inputMetricKeys;
        private final NewCoverageOutputMetricKeys outputMetricKeys;

        public NewLinesAndConditionsFormula(ScmInfoRepository scmInfoRepository, NewCoverageInputMetricKeys inputMetricKeys, NewCoverageOutputMetricKeys outputMetricKeys) {
            this.scmInfoRepository = scmInfoRepository;
            this.inputMetricKeys = inputMetricKeys;
            this.outputMetricKeys = outputMetricKeys;
        }

        @Override
        public NewCoverageCounter createNewCounter() {
            return new NewCoverageCounter(this.scmInfoRepository, this.inputMetricKeys);
        }

        @Override
        public Optional<Measure> createMeasure(NewCoverageCounter counter, CreateMeasureContext context) {
            if (counter.hasNewCode()) {
                int value = this.computeValueForMetric(counter, context.getMetric());
                return Optional.of((Object)Measure.newMeasureBuilder().setVariation(value).createNoValue());
            }
            return Optional.absent();
        }

        private int computeValueForMetric(NewCoverageCounter counter, Metric metric) {
            if (metric.getKey().equals(this.outputMetricKeys.getNewLinesToCover())) {
                return counter.getNewLines();
            }
            if (metric.getKey().equals(this.outputMetricKeys.getNewUncoveredLines())) {
                return counter.getNewLines() - counter.getNewCoveredLines();
            }
            if (metric.getKey().equals(this.outputMetricKeys.getNewConditionsToCover())) {
                return counter.getNewConditions();
            }
            if (metric.getKey().equals(this.outputMetricKeys.getNewUncoveredConditions())) {
                return counter.getNewConditions() - counter.getNewCoveredConditions();
            }
            throw new IllegalArgumentException("Unsupported metric " + metric.getKey());
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{this.outputMetricKeys.getNewLinesToCover(), this.outputMetricKeys.getNewUncoveredLines(), this.outputMetricKeys.getNewConditionsToCover(), this.outputMetricKeys.getNewUncoveredConditions()};
        }
    }

    private static class NewLineCoverageFormula
    extends SingleWithUncoveredVariationFormula {
        public NewLineCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("new_lines_to_cover", "new_uncovered_lines"), "new_line_coverage");
        }
    }

    private static class NewBranchCoverageFormula
    extends SingleWithUncoveredVariationFormula {
        public NewBranchCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("new_conditions_to_cover", "new_uncovered_conditions"), "new_branch_coverage");
        }
    }

    private static class NewCoverageFormula
    extends LinesAndConditionsWithUncoveredVariationFormula {
        public NewCoverageFormula() {
            super(new LinesAndConditionsWithUncoveredMetricKeys("new_lines_to_cover", "new_conditions_to_cover", "new_uncovered_lines", "new_uncovered_conditions"), "new_coverage");
        }
    }

    private static class NewLinesAndConditionsCoverageFormula
    extends NewLinesAndConditionsFormula {
        private static final NewCoverageOutputMetricKeys OUTPUT_METRIC_KEYS = new NewCoverageOutputMetricKeys("new_lines_to_cover", "new_uncovered_lines", "new_conditions_to_cover", "new_uncovered_conditions");
        private static final Iterable<Formula<?>> VIEWS_FORMULAS = NewLinesAndConditionsCoverageFormula.variationSumFormulas(OUTPUT_METRIC_KEYS);

        private NewLinesAndConditionsCoverageFormula(ScmInfoRepository scmInfoRepository) {
            super(scmInfoRepository, new NewCoverageInputMetricKeys("coverage_line_hits_data", "conditions_by_line", "covered_conditions_by_line"), OUTPUT_METRIC_KEYS);
        }

        public static Iterable<Formula<?>> from(@Nullable ScmInfoRepository scmInfoRepository) {
            if (scmInfoRepository == null) {
                return VIEWS_FORMULAS;
            }
            return Collections.singleton(new NewLinesAndConditionsCoverageFormula(scmInfoRepository));
        }

        private static Iterable<Formula<?>> variationSumFormulas(NewCoverageOutputMetricKeys outputMetricKeys) {
            return ImmutableList.of((Object)new VariationSumFormula(outputMetricKeys.getNewLinesToCover()), (Object)new VariationSumFormula(outputMetricKeys.getNewUncoveredLines()), (Object)new VariationSumFormula(outputMetricKeys.getNewConditionsToCover()), (Object)new VariationSumFormula(outputMetricKeys.getNewUncoveredConditions()));
        }
    }
}

