/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.ZipUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.queue.CeTask;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeTaskInputDao;
import org.sonar.process.FileUtils2;
import org.sonar.server.computation.task.projectanalysis.batch.MutableBatchReportDirectoryHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class ExtractReportStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(ExtractReportStep.class);
    private final DbClient dbClient;
    private final CeTask task;
    private final TempFolder tempFolder;
    private final MutableBatchReportDirectoryHolder reportDirectoryHolder;

    public ExtractReportStep(DbClient dbClient, CeTask task, TempFolder tempFolder, MutableBatchReportDirectoryHolder reportDirectoryHolder) {
        this.dbClient = dbClient;
        this.task = task;
        this.tempFolder = tempFolder;
        this.reportDirectoryHolder = reportDirectoryHolder;
    }

    @Override
    public void execute() {
        block43: {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                Optional opt = this.dbClient.ceTaskInputDao().selectData(dbSession, this.task.getUuid());
                if (opt.isPresent()) {
                    File unzippedDir = this.tempFolder.newDir();
                    try (CeTaskInputDao.DataStream reportStream = (CeTaskInputDao.DataStream)opt.get();
                         BufferedInputStream zipStream = new BufferedInputStream(reportStream.getInputStream());){
                        ZipUtils.unzip((InputStream)zipStream, (File)unzippedDir);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Fail to extract report " + this.task.getUuid() + " from database", e);
                    }
                    this.reportDirectoryHolder.setDirectory(unzippedDir);
                    if (LOGGER.isDebugEnabled()) {
                        try {
                            String dirSize = FileUtils.byteCountToDisplaySize((long)FileUtils2.sizeOf((Path)unzippedDir.toPath()));
                            LOGGER.debug("Analysis report is {} uncompressed", (Object)dirSize);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Fail to compute size of directory " + unzippedDir, (Throwable)e);
                        }
                    }
                    break block43;
                }
                throw MessageException.of((String)("Analysis report " + this.task.getUuid() + " is missing in database"));
            }
        }
    }

    @Override
    public String getDescription() {
        return "Extract report";
    }
}

