/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.HashMap;
import java.util.Map;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;

public class ComputeQProfileMeasureStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MeasureRepository measureRepository;
    private final MetricRepository metricRepository;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public ComputeQProfileMeasureStep(TreeRootHolder treeRootHolder, MeasureRepository measureRepository, MetricRepository metricRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
        this.metricRepository = metricRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void execute() {
        Metric qProfilesMetric = this.metricRepository.getByKey("quality_profiles");
        new PathAwareCrawler<QProfiles>(new QProfileAggregationComponentVisitor(qProfilesMetric)).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute Quality profile measures";
    }

    private static class QProfiles {
        private final Map<String, QualityProfile> profilesByKey = new HashMap<String, QualityProfile>();

        private QProfiles() {
        }

        public void add(QProfiles qProfiles) {
            this.profilesByKey.putAll(qProfiles.profilesByKey);
        }

        public void add(QualityProfile qProfile) {
            this.profilesByKey.put(qProfile.getQpKey(), qProfile);
        }

        public Measure createMeasure() {
            return Measure.newMeasureBuilder().create(QPMeasureData.toJson(new QPMeasureData(this.profilesByKey.values())));
        }
    }

    private class QProfileAggregationComponentVisitor
    extends PathAwareVisitorAdapter<QProfiles> {
        private final Metric qProfilesMetric;

        public QProfileAggregationComponentVisitor(Metric qProfilesMetric) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER, new PathAwareVisitorAdapter.SimpleStackElementFactory<QProfiles>(){

                @Override
                public QProfiles createForAny(Component component) {
                    return new QProfiles();
                }
            });
            this.qProfilesMetric = qProfilesMetric;
        }

        @Override
        public void visitFile(Component file, PathAwareVisitor.Path<QProfiles> path) {
            String languageKey = file.getFileAttributes().getLanguageKey();
            if (languageKey == null) {
                return;
            }
            if (!ComputeQProfileMeasureStep.this.analysisMetadataHolder.getQProfilesByLanguage().containsKey(languageKey)) {
                throw new IllegalStateException("Report contains a file with language '" + languageKey + "' but no matching quality profile");
            }
            path.parent().add(ComputeQProfileMeasureStep.this.analysisMetadataHolder.getQProfilesByLanguage().get(languageKey));
        }

        @Override
        public void visitDirectory(Component directory, PathAwareVisitor.Path<QProfiles> path) {
            QProfiles qProfiles = path.current();
            path.parent().add(qProfiles);
        }

        @Override
        public void visitProject(Component project, PathAwareVisitor.Path<QProfiles> path) {
            this.addMeasure(project, path.current());
        }

        @Override
        public void visitModule(Component module, PathAwareVisitor.Path<QProfiles> path) {
            QProfiles qProfiles = path.current();
            this.addMeasure(module, path.current());
            path.parent().add(qProfiles);
        }

        private void addMeasure(Component component, QProfiles qProfiles) {
            if (!qProfiles.profilesByKey.isEmpty()) {
                ComputeQProfileMeasureStep.this.measureRepository.add(component, this.qProfilesMetric, qProfiles.createMeasure());
            }
        }
    }
}

