/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.formula.SumFormula;
import org.sonar.server.computation.task.projectanalysis.formula.counter.IntSumCounter;
import org.sonar.server.computation.task.projectanalysis.formula.counter.SumCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class CommentMeasuresStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final ImmutableList<Formula> formulas;

    public CommentMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.formulas = ImmutableList.of((Object)SumFormula.createIntSumFormula("commented_out_code_lines"), (Object)new DocumentationFormula(), (Object)new CommentDensityFormula());
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)this.formulas)).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute comment measures";
    }

    private static class DocumentationCounter
    implements Counter<DocumentationCounter> {
        private final SumCounter publicApiCounter = new IntSumCounter("public_api");
        private final SumCounter publicUndocumentedApiCounter = new IntSumCounter("public_undocumented_api");

        @Override
        public void aggregate(DocumentationCounter counter) {
            this.publicApiCounter.aggregate(counter.publicApiCounter);
            this.publicUndocumentedApiCounter.aggregate(counter.publicUndocumentedApiCounter);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            this.publicApiCounter.initialize(context);
            this.publicUndocumentedApiCounter.initialize(context);
        }

        public Optional<Integer> getPublicApiValue() {
            return this.publicApiCounter.getValue();
        }

        public Optional<Integer> getPublicUndocumentedApiValue() {
            return this.publicUndocumentedApiCounter.getValue();
        }
    }

    private static class DocumentationFormula
    implements Formula<DocumentationCounter> {
        private DocumentationFormula() {
        }

        @Override
        public DocumentationCounter createNewCounter() {
            return new DocumentationCounter();
        }

        @Override
        public Optional<Measure> createMeasure(DocumentationCounter counter, CreateMeasureContext context) {
            return DocumentationFormula.getMeasure(context, counter.getPublicApiValue(), "public_api").or(DocumentationFormula.getMeasure(context, counter.getPublicUndocumentedApiValue(), "public_undocumented_api")).or(DocumentationFormula.getDensityMeasure(counter, context));
        }

        private static Optional<Measure> getMeasure(CreateMeasureContext context, Optional<Integer> metricValue, String metricKey) {
            if (context.getMetric().getKey().equals(metricKey) && metricValue.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(context.getComponent().getType())) {
                return Optional.of((Object)Measure.newMeasureBuilder().create((Integer)metricValue.get()));
            }
            return Optional.absent();
        }

        private static Optional<Measure> getDensityMeasure(DocumentationCounter counter, CreateMeasureContext context) {
            if (context.getMetric().getKey().equals("public_documented_api_density") && counter.getPublicApiValue().isPresent() && counter.getPublicUndocumentedApiValue().isPresent()) {
                double publicApis = ((Integer)counter.getPublicApiValue().get()).intValue();
                double publicUndocumentedApis = ((Integer)counter.getPublicUndocumentedApiValue().get()).intValue();
                if (publicApis > 0.0) {
                    double documentedAPI = publicApis - publicUndocumentedApis;
                    double value = 100.0 * (documentedAPI / publicApis);
                    return Optional.of((Object)Measure.newMeasureBuilder().create(value, context.getMetric().getDecimalScale()));
                }
            }
            return Optional.absent();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"public_api", "public_undocumented_api", "public_documented_api_density"};
        }
    }

    private class CommentDensityFormula
    implements Formula<IntSumCounter> {
        private final Metric nclocMetric;

        public CommentDensityFormula() {
            this.nclocMetric = CommentMeasuresStep.this.metricRepository.getByKey("ncloc");
        }

        @Override
        public IntSumCounter createNewCounter() {
            return new IntSumCounter("comment_lines");
        }

        @Override
        public Optional<Measure> createMeasure(IntSumCounter counter, CreateMeasureContext context) {
            return this.createCommentLinesMeasure(counter, context).or(this.createCommentLinesDensityMeasure(counter, context));
        }

        private Optional<Measure> createCommentLinesMeasure(SumCounter counter, CreateMeasureContext context) {
            Optional commentLines = counter.getValue();
            if ("comment_lines".equals(context.getMetric().getKey()) && commentLines.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(context.getComponent().getType())) {
                return Optional.of((Object)Measure.newMeasureBuilder().create((Integer)commentLines.get()));
            }
            return Optional.absent();
        }

        private Optional<Measure> createCommentLinesDensityMeasure(SumCounter counter, CreateMeasureContext context) {
            if ("comment_lines_density".equals(context.getMetric().getKey())) {
                double comments;
                double nclocs;
                double divisor;
                Optional<Measure> nclocsOpt = CommentMeasuresStep.this.measureRepository.getRawMeasure(context.getComponent(), this.nclocMetric);
                Optional commentsOpt = counter.getValue();
                if (nclocsOpt.isPresent() && commentsOpt.isPresent() && (divisor = (nclocs = (double)((Measure)nclocsOpt.get()).getIntValue()) + (comments = (double)((Integer)commentsOpt.get()).intValue())) > 0.0) {
                    double value = 100.0 * (comments / divisor);
                    return Optional.of((Object)Measure.newMeasureBuilder().create(value, context.getMetric().getDecimalScale()));
                }
            }
            return Optional.absent();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"comment_lines", "comment_lines_density"};
        }
    }
}

