/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.server.computation.task.projectanalysis.qualitygate.MutableQualityGateHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGate;

public class QualityGateHolderImpl
implements MutableQualityGateHolder {
    private boolean initialized = false;
    @CheckForNull
    private Optional<QualityGate> qualityGate;

    @Override
    public void setQualityGate(QualityGate qualityGate) {
        Objects.requireNonNull(qualityGate);
        this.checkNotInitialized();
        this.initialized = true;
        this.qualityGate = Optional.of((Object)qualityGate);
    }

    @Override
    public void setNoQualityGate() {
        this.checkNotInitialized();
        this.initialized = true;
        this.qualityGate = Optional.absent();
    }

    private void checkNotInitialized() {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"QualityGateHolder can be initialized only once");
    }

    @Override
    public Optional<QualityGate> getQualityGate() {
        Preconditions.checkState((boolean)this.initialized, (Object)"QualityGate has not been set yet");
        return this.qualityGate;
    }
}

