/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.measure;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.computation.task.projectanalysis.component.Developer;
import org.sonar.server.computation.task.projectanalysis.measure.QualityGateStatus;

public final class Measure {
    private final ValueType valueType;
    @CheckForNull
    private final Developer developer;
    @CheckForNull
    private final Double value;
    @CheckForNull
    private final String data;
    @CheckForNull
    private final Level dataLevel;
    @CheckForNull
    private final QualityGateStatus qualityGateStatus;
    @CheckForNull
    private final Double variation;

    private Measure(ValueType valueType, @Nullable Developer developer, @Nullable Double value, @Nullable String data, @Nullable Level dataLevel, @Nullable QualityGateStatus qualityGateStatus, @Nullable Double variation) {
        this.valueType = valueType;
        this.developer = developer;
        this.value = value;
        this.data = data;
        this.dataLevel = dataLevel;
        this.qualityGateStatus = qualityGateStatus;
        this.variation = variation;
    }

    public static NewMeasureBuilder newMeasureBuilder() {
        return new NewMeasureBuilder();
    }

    public static UpdateMeasureBuilder updatedMeasureBuilder(Measure measure) {
        return new UpdateMeasureBuilder(measure);
    }

    @CheckForNull
    public Developer getDeveloper() {
        return this.developer;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean getBooleanValue() {
        this.checkValueType(ValueType.BOOLEAN);
        return this.value == 1.0;
    }

    public int getIntValue() {
        this.checkValueType(ValueType.INT);
        return this.value.intValue();
    }

    public long getLongValue() {
        this.checkValueType(ValueType.LONG);
        return this.value.longValue();
    }

    public double getDoubleValue() {
        this.checkValueType(ValueType.DOUBLE);
        return this.value;
    }

    public String getStringValue() {
        this.checkValueType(ValueType.STRING);
        return this.data;
    }

    public Level getLevelValue() {
        this.checkValueType(ValueType.LEVEL);
        return this.dataLevel;
    }

    public String getData() {
        return this.data;
    }

    private void checkValueType(ValueType expected) {
        if (this.valueType != expected) {
            throw new IllegalStateException(String.format("value can not be converted to %s because current value type is a %s", new Object[]{expected.toString().toLowerCase(Locale.US), this.valueType}));
        }
    }

    public boolean hasQualityGateStatus() {
        return this.qualityGateStatus != null;
    }

    public QualityGateStatus getQualityGateStatus() {
        Preconditions.checkState((this.qualityGateStatus != null ? 1 : 0) != 0, (Object)"Measure does not have an QualityGate status");
        return this.qualityGateStatus;
    }

    public boolean hasVariation() {
        return this.variation != null;
    }

    public double getVariation() {
        Preconditions.checkState((this.variation != null ? 1 : 0) != 0, (Object)"Measure does not have variation");
        return this.variation;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measure measure = (Measure)o;
        return Objects.equals(this.developer, measure.developer);
    }

    public int hashCode() {
        return Objects.hash(this.developer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueType", (Object)this.valueType).add("developer", (Object)this.developer).add("value", (Object)this.value).add("data", (Object)this.data).add("dataLevel", (Object)this.dataLevel).add("qualityGateStatus", (Object)this.qualityGateStatus).add("variations", (Object)this.variation).toString();
    }

    public static final class UpdateMeasureBuilder {
        private final Measure source;
        private QualityGateStatus qualityGateStatus;
        private Double variation;

        public UpdateMeasureBuilder(Measure source) {
            this.source = Objects.requireNonNull(source, "Can not create a measure from null");
        }

        public UpdateMeasureBuilder setQualityGateStatus(QualityGateStatus qualityGateStatus) {
            if (this.source.qualityGateStatus != null) {
                throw new UnsupportedOperationException("QualityGate status can not be changed if already set on source Measure");
            }
            this.qualityGateStatus = Objects.requireNonNull(qualityGateStatus, "QualityGateStatus can not be set to null");
            return this;
        }

        public UpdateMeasureBuilder setVariation(double variation) {
            if (this.source.variation != null) {
                throw new UnsupportedOperationException("Variation can not be changed if already set on source Measure");
            }
            this.variation = variation;
            return this;
        }

        public Measure create() {
            return new Measure(this.source.valueType, this.source.developer, this.source.value, this.source.data, this.source.dataLevel, this.source.qualityGateStatus == null ? this.qualityGateStatus : this.source.qualityGateStatus, this.source.variation == null ? this.variation : this.source.variation);
        }
    }

    public static final class NewMeasureBuilder {
        private Developer developer;
        private QualityGateStatus qualityGateStatus;
        private Double variation;

        public NewMeasureBuilder forDeveloper(Developer developer) {
            this.developer = developer;
            return this;
        }

        public NewMeasureBuilder setQualityGateStatus(QualityGateStatus qualityGateStatus) {
            this.qualityGateStatus = Objects.requireNonNull(qualityGateStatus, "QualityGateStatus can not be set to null");
            return this;
        }

        public NewMeasureBuilder setVariation(double variation) {
            this.variation = variation;
            return this;
        }

        public Measure create(boolean value, @Nullable String data) {
            return new Measure(ValueType.BOOLEAN, this.developer, value ? 1.0 : 0.0, data, null, this.qualityGateStatus, this.variation);
        }

        public Measure create(boolean value) {
            return this.create(value, null);
        }

        public Measure create(int value, @Nullable String data) {
            return new Measure(ValueType.INT, this.developer, Double.valueOf(value), data, null, this.qualityGateStatus, this.variation);
        }

        public Measure create(int value) {
            return this.create(value, (String)null);
        }

        public Measure create(long value, @Nullable String data) {
            return new Measure(ValueType.LONG, this.developer, Double.valueOf(value), data, null, this.qualityGateStatus, this.variation);
        }

        public Measure create(long value) {
            return this.create(value, null);
        }

        public Measure create(double value, int decimalScale, @Nullable String data) {
            Preconditions.checkArgument((!Double.isNaN(value) ? 1 : 0) != 0, (Object)"NaN is not allowed as a Measure value");
            double scaledValue = NewMeasureBuilder.scale(value, decimalScale);
            return new Measure(ValueType.DOUBLE, this.developer, scaledValue, data, null, this.qualityGateStatus, this.variation);
        }

        public Measure create(double value, int decimalScale) {
            return this.create(value, decimalScale, null);
        }

        public Measure create(String value) {
            return new Measure(ValueType.STRING, this.developer, null, Objects.requireNonNull(value), null, this.qualityGateStatus, this.variation);
        }

        public Measure create(Level level) {
            return new Measure(ValueType.LEVEL, this.developer, null, null, Objects.requireNonNull(level), this.qualityGateStatus, this.variation);
        }

        public Measure createNoValue() {
            return new Measure(ValueType.NO_VALUE, this.developer, null, null, null, this.qualityGateStatus, this.variation);
        }

        private static double scale(double value, int decimalScale) {
            BigDecimal bd = BigDecimal.valueOf(value);
            return bd.setScale(decimalScale, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public static enum Level {
        OK("Green"),
        WARN("Orange"),
        ERROR("Red");

        private final String colorName;

        private Level(String colorName) {
            this.colorName = colorName;
        }

        public String getColorName() {
            return this.colorName;
        }

        public static Optional<Level> toLevel(@Nullable String level) {
            if (level == null) {
                return Optional.absent();
            }
            try {
                return Optional.of((Object)((Object)Level.valueOf(level)));
            }
            catch (IllegalArgumentException e) {
                return Optional.absent();
            }
        }
    }

    public static enum ValueType {
        NO_VALUE,
        BOOLEAN,
        INT,
        LONG,
        DOUBLE,
        STRING,
        LEVEL;

    }
}

