/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndex;
import org.sonar.server.util.cache.CacheLoader;

public class ScmAccountToUserLoader
implements CacheLoader<String, String> {
    private static final Logger LOGGER = Loggers.get(ScmAccountToUserLoader.class);
    private final UserIndex index;

    public ScmAccountToUserLoader(UserIndex index) {
        this.index = index;
    }

    @Override
    public String load(String scmAccount) {
        List<UserDoc> users = this.index.getAtMostThreeActiveUsersForScmAccount(scmAccount);
        if (users.size() == 1) {
            return users.get(0).login();
        }
        if (!users.isEmpty()) {
            Collection logins = (Collection)users.stream().map(UserDoc::login).sorted((Comparator<String>)Ordering.natural()).collect(MoreCollectors.toList((int)users.size()));
            LOGGER.warn(String.format("Multiple users share the SCM account '%s': %s", scmAccount, Joiner.on((String)", ").join((Iterable)logins)));
        }
        return null;
    }

    @Override
    public Map<String, String> loadAll(Collection<? extends String> scmAccounts) {
        throw new UnsupportedOperationException("Loading by multiple scm accounts is not supported yet");
    }
}

